/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import javax.annotation.Nullable;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.grouplens.lenskit.eval.EvalConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalProject {
    private static final Logger logger = LoggerFactory.getLogger(EvalProject.class);
    private Project antProject;
    private Random random = new Random();
    private String defaultTarget;

    public EvalProject(@Nullable Properties props) {
        this.antProject = new Project();
        this.antProject.init();
        this.antProject.addBuildListener((BuildListener)new Listener());
        if (props != null) {
            PropertyHelper ph = PropertyHelper.getPropertyHelper((Project)this.antProject);
            for (Map.Entry<Object, Object> prop : props.entrySet()) {
                ph.setProperty(prop.getKey().toString(), (Object)prop.getValue().toString(), false);
            }
        }
    }

    public Project getAntProject() {
        return this.antProject;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public EvalConfig getConfig() {
        return new EvalConfig(this.antProject.getProperties());
    }

    public String getProperty(String propertyName) {
        return this.antProject.getProperty(propertyName);
    }

    public void setUserProperty(String name, String value) {
        this.antProject.setUserProperty(name, value);
    }

    public void executeTarget(String name) throws BuildException {
        this.antProject.executeTarget(name);
    }

    public void executeTargets(String ... names) {
        Vector targets = this.antProject.topoSort(names, this.antProject.getTargets(), false);
        this.antProject.executeSortedTargets(targets);
    }

    public void executeTargets(List<String> names) {
        String[] nameArray = (String[])Iterables.toArray(names, String.class);
        Vector targets = this.antProject.topoSort(nameArray, this.antProject.getTargets(), false);
        this.antProject.executeSortedTargets(targets);
    }

    public String getDefaultTarget() {
        return this.defaultTarget;
    }

    public void setDefaultTarget(String defaultTarget) {
        this.defaultTarget = defaultTarget;
    }

    private static class Listener
    implements BuildListener {
        String target;
        String task;

        private Listener() {
        }

        public void buildStarted(BuildEvent event) {
            logger.info("started build of project " + event.getProject());
        }

        public void buildFinished(BuildEvent event) {
            logger.info("finished build of project " + event.getProject());
        }

        public void targetStarted(BuildEvent event) {
            this.target = event.getTarget().getName();
            logger.info("running target " + this.target);
        }

        public void targetFinished(BuildEvent event) {
            logger.debug("finished target {}", (Object)event.getTarget().getName());
            this.target = null;
        }

        public void taskStarted(BuildEvent event) {
            this.task = event.getTask().getTaskName();
            logger.info("running task {}", (Object)this.task);
        }

        public void taskFinished(BuildEvent event) {
            logger.debug("task {} finished", (Object)event.getTask().getTaskName());
            this.task = null;
        }

        public void messageLogged(BuildEvent event) {
            switch (event.getPriority()) {
                case 0: {
                    logger.error("{}:{}: {}", new Object[]{this.target, this.task, event.getMessage()});
                    break;
                }
                case 1: {
                    logger.warn("{}:{}: {}", new Object[]{this.target, this.task, event.getMessage()});
                    break;
                }
                case 2: {
                    logger.info("{}:{}: {}", new Object[]{this.target, this.task, event.getMessage()});
                    break;
                }
                case 4: {
                    logger.debug("{}:{}: {}", new Object[]{this.target, this.task, event.getMessage()});
                    break;
                }
                case 3: {
                    logger.trace("{}:{}: {}", new Object[]{this.target, this.task, event.getMessage()});
                }
            }
        }
    }
}

