/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval;

import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.grouplens.lenskit.eval.EvalAntTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalTarget
extends Target
implements ListenableFuture<Object> {
    private static final Logger logger = LoggerFactory.getLogger(EvalTarget.class);
    protected final SettableFuture<Object> returnValue = SettableFuture.create();
    protected Future<?> lastTaskFuture = null;
    protected Task lastTask = null;

    public void addTask(Task task) {
        logger.debug("adding task {} to {}", (Object)task, (Object)this.getName());
        super.addTask(task);
        this.lastTask = task;
        this.lastTaskFuture = task instanceof EvalAntTask ? ((EvalAntTask)task).getEvalTask() : null;
    }

    public void execute() throws BuildException {
        try {
            logger.info("beginning execution of {}", (Object)this.getName());
            Stopwatch watch = new Stopwatch().start();
            super.execute();
            watch.stop();
            logger.info("{} finished in {}", (Object)this.getName(), (Object)watch);
            if (this.lastTaskFuture != null) {
                if (!this.lastTaskFuture.isDone()) {
                    logger.error("{}: future for task {} did not complete", (Object)this.getName(), (Object)this.lastTask);
                    this.returnValue.setException((Throwable)new RuntimeException("task future didn't complete"));
                } else {
                    while (!this.returnValue.isDone()) {
                        try {
                            this.returnValue.set(this.lastTaskFuture.get());
                        }
                        catch (ExecutionException ex) {
                            this.returnValue.setException(ex.getCause());
                        }
                        catch (InterruptedException e) {
                            logger.warn("{}: task future get() was interrupted", (Object)this.getName());
                        }
                    }
                }
            } else {
                this.returnValue.set(null);
            }
        }
        catch (RuntimeException ex) {
            this.returnValue.setException((Throwable)ex);
            throw ex;
        }
    }

    public Object get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        return this.returnValue.get(timeout, unit);
    }

    public Object get() throws InterruptedException, ExecutionException {
        return this.returnValue.get();
    }

    public boolean isDone() {
        return this.returnValue.isDone();
    }

    public boolean isCancelled() {
        return this.returnValue.isCancelled();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.returnValue.cancel(mayInterruptIfRunning);
    }

    public void addListener(Runnable listener, Executor exec) {
        this.returnValue.addListener(listener, exec);
    }
}

