/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.grouplens.lenskit.core.Shareable;

@Shareable
public class ExecutionInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String algoName;
    private final Map<String, Object> algoAttributes;
    private final String dataName;
    private final Map<String, Object> dataAttributes;

    private ExecutionInfo(String aName, Map<String, Object> aAttrs, String dsName, Map<String, Object> dsAttrs) {
        this.algoName = aName;
        this.algoAttributes = ImmutableMap.copyOf(aAttrs);
        this.dataName = dsName;
        this.dataAttributes = ImmutableMap.copyOf(dsAttrs);
    }

    public String getAlgoName() {
        return this.algoName;
    }

    public Map<String, Object> getAlgoAttributes() {
        return this.algoAttributes;
    }

    public String getDataName() {
        return this.dataName;
    }

    public Map<String, Object> getDataAttributes() {
        return this.dataAttributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ExecutionInfo) {
            ExecutionInfo eo = (ExecutionInfo)o;
            EqualsBuilder eqb = new EqualsBuilder();
            return eqb.append((Object)this.algoName, (Object)eo.algoName).append(this.algoAttributes, eo.algoAttributes).append((Object)this.dataName, (Object)eo.dataName).append(this.dataAttributes, eo.dataAttributes).isEquals();
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        return hcb.append((Object)this.algoName).append(this.algoAttributes).append((Object)this.dataName).append(this.dataAttributes).hashCode();
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<ExecutionInfo> {
        private String algoName;
        private Map<String, Object> algoAttributes = new HashMap<String, Object>();
        private String dataName;
        private Map<String, Object> dataAttributes = new HashMap<String, Object>();

        public Builder setAlgoName(String algoName) {
            this.algoName = algoName;
            return this;
        }

        public Builder setAlgoAttributes(Map<String, Object> attrs) {
            this.algoAttributes = new HashMap<String, Object>(attrs);
            return this;
        }

        public Builder setDataName(String dataName) {
            this.dataName = dataName;
            return this;
        }

        public Builder setDataAttributes(Map<String, Object> attrs) {
            this.dataAttributes = new HashMap<String, Object>(attrs);
            return this;
        }

        public ExecutionInfo build() {
            return new ExecutionInfo(this.algoName, this.algoAttributes, this.dataName, this.dataAttributes);
        }
    }
}

