/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.File;
import org.apache.commons.lang3.time.StopWatch;
import org.grouplens.lenskit.RecommenderBuildException;
import org.grouplens.lenskit.core.LenskitRecommender;
import org.grouplens.lenskit.eval.AbstractTask;
import org.grouplens.lenskit.eval.TaskExecutionException;
import org.grouplens.lenskit.eval.algorithm.LenskitAlgorithmInstance;
import org.grouplens.lenskit.eval.data.DataSource;
import org.grouplens.lenskit.util.LogContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainModelTask<T>
extends AbstractTask<T> {
    private static final Logger logger = LoggerFactory.getLogger(TrainModelTask.class);
    private LenskitAlgorithmInstance algorithm;
    private File writeFile;
    private DataSource inputData;
    private Function<LenskitRecommender, T> action;

    public TrainModelTask() {
        super("train-model");
    }

    public TrainModelTask(String name) {
        super(name);
    }

    public LenskitAlgorithmInstance getAlgorithm() {
        return this.algorithm;
    }

    public File getWriteFile() {
        return this.writeFile;
    }

    public DataSource getInputData() {
        return this.inputData;
    }

    public Function<LenskitRecommender, T> getAction() {
        return this.action;
    }

    public TrainModelTask setAlgorithm(LenskitAlgorithmInstance algo) {
        this.algorithm = algo;
        return this;
    }

    public TrainModelTask setWriteFile(File file) {
        this.writeFile = file;
        return this;
    }

    public TrainModelTask setInput(DataSource data) {
        this.inputData = data;
        return this;
    }

    public TrainModelTask setAction(Function<LenskitRecommender, T> act) {
        this.action = act;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T perform() throws TaskExecutionException {
        Preconditions.checkState((this.algorithm != null ? 1 : 0) != 0, (Object)"no algorithm specified");
        Preconditions.checkState((this.inputData != null ? 1 : 0) != 0, (Object)"no input data specified");
        Preconditions.checkState((this.inputData != null ? 1 : 0) != 0, (Object)"no action specified");
        LogContext context = new LogContext();
        try {
            LenskitRecommender rec;
            context.put("lenskit.eval.command.class", this.getName());
            context.put("lenskit.eval.command.name", this.getName());
            context.put("lenskit.eval.algorithm.name", this.algorithm.getName());
            StopWatch timer = new StopWatch();
            timer.start();
            try {
                logger.info("{}: building recommender {}", (Object)this.getName(), (Object)this.algorithm.getName());
                rec = this.algorithm.buildRecommender(this.inputData, null, null);
            }
            catch (RecommenderBuildException e) {
                throw new TaskExecutionException(this.getName() + ": error building recommender", e);
            }
            timer.stop();
            logger.info("{}: trained in {}", (Object)this.getName(), (Object)timer);
            Object object = this.action.apply((Object)rec);
            return (T)object;
        }
        finally {
            context.finish();
        }
    }
}

