/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.algorithm;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import it.unimi.dsi.fastutil.longs.Long2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.apache.commons.lang3.StringUtils;
import org.grouplens.lenskit.Recommender;
import org.grouplens.lenskit.RecommenderBuildException;
import org.grouplens.lenskit.collections.CollectionUtils;
import org.grouplens.lenskit.cursors.Cursor;
import org.grouplens.lenskit.data.dao.EventDAO;
import org.grouplens.lenskit.data.dao.UserEventDAO;
import org.grouplens.lenskit.data.event.Rating;
import org.grouplens.lenskit.data.pref.Preference;
import org.grouplens.lenskit.data.snapshot.PreferenceSnapshot;
import org.grouplens.lenskit.eval.ExecutionInfo;
import org.grouplens.lenskit.eval.algorithm.AlgorithmInstance;
import org.grouplens.lenskit.eval.algorithm.ExternalAlgorithmInstanceBuilder;
import org.grouplens.lenskit.eval.algorithm.RecommenderInstance;
import org.grouplens.lenskit.eval.data.CSVDataSource;
import org.grouplens.lenskit.eval.data.traintest.GenericTTDataSet;
import org.grouplens.lenskit.eval.data.traintest.TTDataSet;
import org.grouplens.lenskit.eval.script.BuiltBy;
import org.grouplens.lenskit.scored.ScoredId;
import org.grouplens.lenskit.util.DelimitedTextCursor;
import org.grouplens.lenskit.util.table.writer.CSVWriter;
import org.grouplens.lenskit.vectors.ImmutableSparseVector;
import org.grouplens.lenskit.vectors.SparseVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BuiltBy(value=ExternalAlgorithmInstanceBuilder.class)
public class ExternalAlgorithmInstance
implements AlgorithmInstance {
    private final Logger logger = LoggerFactory.getLogger(ExternalAlgorithmInstance.class);
    private final String name;
    private final Map<String, Object> attributes;
    private final List<String> command;
    private final File workDir;
    private final String outputDelimiter;

    public ExternalAlgorithmInstance(String name, Map<String, Object> attrs, List<String> cmd, File dir, String delim) {
        this.name = name;
        this.attributes = attrs;
        this.command = cmd;
        this.workDir = dir;
        this.outputDelimiter = delim;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalAlgorithm(").append(this.getName()).append(")");
        if (!this.attributes.isEmpty()) {
            sb.append("[");
            Joiner.on((String)", ").withKeyValueSeparator("=").appendTo(sb, this.attributes);
            sb.append("]");
        }
        return sb.toString();
    }

    private File trainingFile(TTDataSet data) throws IOException {
        try {
            GenericTTDataSet gds = (GenericTTDataSet)data;
            CSVDataSource csv = (CSVDataSource)gds.getTrainingData();
            if (",".equals(csv.getDelimiter())) {
                File file = csv.getFile();
                this.logger.debug("using training file {}", (Object)file);
                return file;
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        File file = this.makeCSV(data.getTrainingDAO(), this.getName() + ".train.csv", true);
        this.logger.debug("wrote training file {}", (Object)file);
        return file;
    }

    private File testFile(TTDataSet data) throws IOException {
        File file = this.makeCSV(data.getTestDAO(), this.getName() + ".test.csv", false);
        this.logger.debug("wrote test file {}", (Object)file);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File makeCSV(EventDAO dao, String fn, boolean writeRatings) throws IOException {
        File file = new File(this.workDir, fn);
        Object[] row = new Object[writeRatings ? 3 : 2];
        CSVWriter table = CSVWriter.open(file, null);
        try {
            Cursor ratings = dao.streamEvents(Rating.class);
            try {
                for (Rating r : ratings) {
                    Preference p = r.getPreference();
                    if (p == null) continue;
                    row[0] = r.getUserId();
                    row[1] = r.getItemId();
                    if (writeRatings) {
                        row[2] = p.getValue();
                    }
                    table.writeRow(row);
                }
            }
            finally {
                ratings.close();
            }
        }
        finally {
            table.close();
        }
        return file;
    }

    @Override
    public RecommenderInstance makeTestableRecommender(TTDataSet data, Provider<? extends PreferenceSnapshot> snapshot, ExecutionInfo info) throws RecommenderBuildException {
        Long2ObjectMap<SparseVector> vectors;
        Process proc;
        File test;
        File train;
        try {
            train = this.trainingFile(data);
        }
        catch (IOException e) {
            throw new RecommenderBuildException("error preparing training file", (Throwable)e);
        }
        try {
            test = this.testFile(data);
        }
        catch (IOException e) {
            throw new RecommenderBuildException("error preparing test file", (Throwable)e);
        }
        final File output = new File(this.workDir, String.format("%s-%s.predictions.csv", this.getName(), data.getName()));
        List args = Lists.transform(this.command, (Function)new Function<String, String>(){

            @Nullable
            public String apply(@Nullable String input) {
                if (input == null) {
                    throw new IllegalArgumentException("cannot have null command element");
                }
                String s = input.replace("{OUTPUT}", output.getAbsolutePath());
                s = s.replace("{TRAIN_DATA}", train.getAbsolutePath());
                s = s.replace("{TEST_DATA}", test.getAbsolutePath());
                return s;
            }
        });
        this.logger.info("running {}", (Object)StringUtils.join((Iterable)args, (String)" "));
        try {
            proc = new ProcessBuilder(new String[0]).command(args).directory(this.workDir).start();
        }
        catch (IOException e) {
            throw new RecommenderBuildException("error creating process", (Throwable)e);
        }
        ProcessErrorHandler listen = new ProcessErrorHandler(proc.getErrorStream());
        ((Thread)listen).run();
        int result = -1;
        boolean done = false;
        while (!done) {
            try {
                result = proc.waitFor();
                done = true;
            }
            catch (InterruptedException e) {}
        }
        if (result != 0) {
            this.logger.error("external command exited with status {}", (Object)result);
            throw new RecommenderBuildException("recommender exited with code " + result);
        }
        try {
            vectors = this.readPredictions(output);
        }
        catch (FileNotFoundException e) {
            this.logger.error("cannot find expected output file {}", (Object)output);
            throw new RecommenderBuildException("recommender produced no output", (Throwable)e);
        }
        return new RecInstance(data.getTrainingData().getUserEventDAO(), vectors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long2ObjectMap<SparseVector> readPredictions(File predFile) throws FileNotFoundException, RecommenderBuildException {
        Long2ObjectOpenHashMap data = new Long2ObjectOpenHashMap();
        DelimitedTextCursor cursor = new DelimitedTextCursor(predFile, this.outputDelimiter);
        try {
            for (String[] row : cursor) {
                if (row.length < 3) {
                    throw new RecommenderBuildException("invalid prediction row");
                }
                long uid = Long.parseLong(row[0]);
                long iid = Long.parseLong(row[1]);
                double pred = Double.parseDouble(row[2]);
                Long2DoubleMap user = (Long2DoubleMap)data.get(uid);
                if (user == null) {
                    user = new Long2DoubleOpenHashMap();
                    data.put(uid, (Object)user);
                }
                user.put(iid, pred);
            }
        }
        finally {
            cursor.close();
        }
        Long2ObjectOpenHashMap vectors = new Long2ObjectOpenHashMap(data.size());
        for (Long2ObjectMap.Entry entry : CollectionUtils.fast((Iterable)data.long2ObjectEntrySet())) {
            vectors.put(entry.getLongKey(), (Object)new ImmutableSparseVector((Long2DoubleMap)entry.getValue()));
            entry.setValue(null);
        }
        return vectors;
    }

    private class ProcessErrorHandler
    extends Thread {
        private final BufferedReader error;

        public ProcessErrorHandler(InputStream err) {
            super("external");
            this.setDaemon(true);
            this.error = new BufferedReader(new InputStreamReader(err));
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.error.readLine()) != null) {
                    ExternalAlgorithmInstance.this.logger.debug("external: " + line);
                }
            }
            catch (IOException e) {
                ExternalAlgorithmInstance.this.logger.error("IO error reading error stream", (Throwable)e);
            }
        }
    }

    private static class RecInstance
    implements RecommenderInstance {
        private final UserEventDAO dao;
        private final Long2ObjectMap<SparseVector> vectors;

        public RecInstance(UserEventDAO dao, Long2ObjectMap<SparseVector> vs) {
            this.dao = dao;
            this.vectors = vs;
        }

        @Override
        public UserEventDAO getUserEventDAO() {
            return this.dao;
        }

        @Override
        public SparseVector getPredictions(long uid, LongSet testItems) {
            return (SparseVector)this.vectors.get(uid);
        }

        @Override
        public List<ScoredId> getRecommendations(long uid, LongSet testItems, int n) {
            return null;
        }

        @Override
        public Recommender getRecommender() {
            return null;
        }
    }
}

