/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.algorithm;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.Builder;
import org.grouplens.lenskit.eval.algorithm.ExternalAlgorithmInstance;

public class ExternalAlgorithmInstanceBuilder
implements Builder<ExternalAlgorithmInstance> {
    private String name;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private File workDir = new File(".");
    private String outputDelimiter = "\t";
    private List<String> command;

    public ExternalAlgorithmInstanceBuilder() {
        this("Unnamed");
    }

    public ExternalAlgorithmInstanceBuilder(String name) {
        this.name = name;
    }

    public ExternalAlgorithmInstanceBuilder setName(String n) {
        this.name = n;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ExternalAlgorithmInstanceBuilder setAttribute(@Nonnull String attr, @Nonnull Object value) {
        Preconditions.checkNotNull((Object)attr, (Object)"attribute names cannot be null");
        Preconditions.checkNotNull((Object)value, (Object)"attribute values cannot be null");
        this.attributes.put(attr, value);
        return this;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public ExternalAlgorithmInstanceBuilder setCommand(List<String> cmd) {
        this.command = cmd;
        return this;
    }

    public ExternalAlgorithmInstanceBuilder setWorkDir(File dir) {
        this.workDir = dir;
        return this;
    }

    public ExternalAlgorithmInstanceBuilder setOutputDelimiter(String delim) {
        this.outputDelimiter = delim;
        return this;
    }

    public ExternalAlgorithmInstance build() {
        if (this.command == null) {
            throw new IllegalStateException("no command specified");
        }
        return new ExternalAlgorithmInstance(this.getName(), this.attributes, this.command, this.workDir, this.outputDelimiter);
    }
}

