/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.algorithm;

import com.google.common.base.Joiner;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.grouplens.lenskit.ItemRecommender;
import org.grouplens.lenskit.RatingPredictor;
import org.grouplens.lenskit.RecommenderBuildException;
import org.grouplens.lenskit.core.LenskitConfiguration;
import org.grouplens.lenskit.core.LenskitRecommender;
import org.grouplens.lenskit.core.LenskitRecommenderEngine;
import org.grouplens.lenskit.data.dao.EventDAO;
import org.grouplens.lenskit.data.dao.UserEventDAO;
import org.grouplens.lenskit.data.pref.PreferenceDomain;
import org.grouplens.lenskit.data.snapshot.PreferenceSnapshot;
import org.grouplens.lenskit.eval.ExecutionInfo;
import org.grouplens.lenskit.eval.algorithm.AlgorithmInstance;
import org.grouplens.lenskit.eval.algorithm.LenskitAlgorithmInstanceBuilder;
import org.grouplens.lenskit.eval.algorithm.RecommenderInstance;
import org.grouplens.lenskit.eval.data.DataSource;
import org.grouplens.lenskit.eval.data.traintest.TTDataSet;
import org.grouplens.lenskit.eval.script.BuiltBy;
import org.grouplens.lenskit.scored.ScoredId;
import org.grouplens.lenskit.vectors.SparseVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BuiltBy(value=LenskitAlgorithmInstanceBuilder.class)
public class LenskitAlgorithmInstance
implements AlgorithmInstance {
    private static final Logger logger = LoggerFactory.getLogger(LenskitAlgorithmInstance.class);
    @Nullable
    private final String algoName;
    @Nonnull
    private final LenskitConfiguration config;
    @Nonnull
    private final Map<String, Object> attributes;
    private final boolean preload;

    public LenskitAlgorithmInstance(String name, LenskitConfiguration config) {
        this(name, config, Collections.emptyMap(), false);
    }

    public LenskitAlgorithmInstance(String name, LenskitConfiguration cfg, Map<String, Object> attrs, boolean preload) {
        this.algoName = name;
        this.config = cfg;
        this.attributes = attrs;
        this.preload = preload;
    }

    @Override
    public String getName() {
        return this.algoName;
    }

    public boolean getPreload() {
        return this.preload;
    }

    @Override
    @Nonnull
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Nonnull
    public LenskitConfiguration getConfig() {
        return this.config;
    }

    public LenskitRecommender buildRecommender(DataSource data, @Nullable Provider<? extends PreferenceSnapshot> sharedSnapshot, @Nullable ExecutionInfo info) throws RecommenderBuildException {
        LenskitConfiguration cfg = new LenskitConfiguration(this.config);
        PreferenceDomain dom = data.getPreferenceDomain();
        if (dom != null) {
            cfg.bind(PreferenceDomain.class).to((Object)dom);
        }
        if (sharedSnapshot != null) {
            cfg.bind(PreferenceSnapshot.class).toProvider(sharedSnapshot);
        }
        if (info != null) {
            cfg.bind(ExecutionInfo.class).to((Object)info);
        }
        cfg.bind(EventDAO.class).toProvider(data.getEventDAOProvider());
        LenskitRecommenderEngine engine = LenskitRecommenderEngine.build((LenskitConfiguration)cfg);
        return engine.createRecommender();
    }

    @Override
    public RecommenderInstance makeTestableRecommender(TTDataSet data, Provider<? extends PreferenceSnapshot> snapshot, ExecutionInfo info) throws RecommenderBuildException {
        return new RecInstance(this.buildRecommender(data.getTrainingData(), snapshot, info));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LenskitAlgorithm(").append(this.getName()).append(")");
        if (!this.attributes.isEmpty()) {
            sb.append("[");
            Joiner.on((String)", ").withKeyValueSeparator("=").appendTo(sb, this.attributes);
            sb.append("]");
        }
        return sb.toString();
    }

    private static class RecInstance
    implements RecommenderInstance {
        private final LenskitRecommender recommender;

        public RecInstance(LenskitRecommender rec) {
            this.recommender = rec;
        }

        @Override
        public UserEventDAO getUserEventDAO() {
            return (UserEventDAO)this.recommender.get(UserEventDAO.class);
        }

        @Override
        public SparseVector getPredictions(long uid, LongSet testItems) {
            RatingPredictor rp = this.recommender.getRatingPredictor();
            if (rp == null) {
                return null;
            }
            return rp.predict(uid, (Collection)testItems);
        }

        @Override
        public List<ScoredId> getRecommendations(long uid, LongSet testItems, int n) {
            ItemRecommender irec = this.recommender.getItemRecommender();
            if (irec == null) {
                return null;
            }
            return irec.recommend(uid, n, (Set)testItems, null);
        }

        public LenskitRecommender getRecommender() {
            return this.recommender;
        }
    }
}

