/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.algorithm;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.Builder;
import org.grouplens.lenskit.core.LenskitConfiguration;
import org.grouplens.lenskit.eval.algorithm.AlgorithmInstanceBuilderDelegate;
import org.grouplens.lenskit.eval.algorithm.LenskitAlgorithmInstance;
import org.grouplens.lenskit.eval.script.ConfigDelegate;

@ConfigDelegate(value=AlgorithmInstanceBuilderDelegate.class)
public class LenskitAlgorithmInstanceBuilder
implements Builder<LenskitAlgorithmInstance> {
    private final LenskitConfiguration config;
    private String name;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private boolean preload;

    public LenskitAlgorithmInstanceBuilder() {
        this("Unnamed Algorithm");
    }

    public LenskitAlgorithmInstanceBuilder(String name) {
        this.name = name;
        this.config = new LenskitConfiguration();
    }

    public LenskitAlgorithmInstanceBuilder setName(String n) {
        this.name = n;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getPreload() {
        return this.preload;
    }

    public LenskitAlgorithmInstanceBuilder setPreload(boolean pl) {
        this.preload = pl;
        return this;
    }

    public LenskitAlgorithmInstanceBuilder setAttribute(@Nonnull String attr, @Nonnull Object value) {
        Preconditions.checkNotNull((Object)attr, (Object)"attribute names cannot be null");
        Preconditions.checkNotNull((Object)value, (Object)"attribute values cannot be null");
        this.attributes.put(attr, value);
        return this;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public LenskitConfiguration getConfig() {
        return this.config;
    }

    public LenskitAlgorithmInstance build() {
        return new LenskitAlgorithmInstance(this.getName(), this.config, this.attributes, this.preload);
    }
}

