/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.cli;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.tools.ant.Target;
import org.codehaus.groovy.runtime.StackTraceUtils;
import org.grouplens.lenskit.eval.EvalProject;
import org.grouplens.lenskit.eval.TaskExecutionException;
import org.grouplens.lenskit.eval.cli.EvalCLIOptions;
import org.grouplens.lenskit.eval.script.EvalScriptEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalCLI {
    private static final Logger logger = LoggerFactory.getLogger(EvalCLI.class);
    private final EvalCLIOptions options;

    public static void main(String[] args) {
        EvalCLIOptions options = EvalCLIOptions.parse(args);
        EvalCLI cli = new EvalCLI(options);
        cli.run();
    }

    public EvalCLI(EvalCLIOptions opts) {
        this.options = opts;
    }

    public void run() {
        ClassLoader loader = this.options.getClassLoader();
        EvalScriptEngine engine = new EvalScriptEngine(loader, this.options.getProperties());
        File f = this.options.getScriptFile();
        logger.info("loading evaluation from {}", (Object)f);
        try {
            EvalProject project = engine.loadProject(f);
            if (this.options.getArgs().length == 0) {
                String dft = project.getDefaultTarget();
                if (dft == null && !project.getAntProject().getTargets().isEmpty()) {
                    String targets = Joiner.on((String)", ").join(Iterables.transform(project.getAntProject().getTargets().keySet(), (Function)new Function(){

                        @Nullable
                        public Object apply(@Nullable Object input) {
                            return input == null ? null : ((Target)input).getName();
                        }
                    }));
                    logger.error("No targets specified and no default provided (try one of {})", (Object)targets);
                    System.exit(2);
                }
            } else {
                project.executeTargets(this.options.getArgs());
            }
        }
        catch (TaskExecutionException e) {
            this.reportError(e.getCause(), "%s: %s", f.getPath(), e.getMessage());
            return;
        }
        catch (IOException e) {
            this.reportError(e, "%s: %s", f.getPath(), e.getMessage());
            return;
        }
    }

    protected void reportError(@Nullable Throwable e, String msg, Object ... args) {
        String text = String.format(msg, args);
        System.err.println(text);
        if (e instanceof ExecutionException) {
            e = e.getCause();
        }
        if (this.options.throwErrors()) {
            throw new RuntimeException(text, e);
        }
        if (e != null) {
            StackTraceUtils.sanitize((Throwable)e).printStackTrace(System.err);
        }
        System.exit(2);
    }
}

