/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.cli;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalCLIOptions {
    private static final Logger logger = LoggerFactory.getLogger(EvalCLIOptions.class);
    private String[] args;
    private File configFile = new File("eval.groovy");
    private URL[] classpathUrls;
    private Properties props;
    private boolean force;
    private int nthreads = 1;

    private EvalCLIOptions(CommandLine cmd) {
        String[] cpadds = cmd.getOptionValues("C");
        if (cpadds != null) {
            this.classpathUrls = new URL[cpadds.length];
            for (int i = 0; i < cpadds.length; ++i) {
                URL url = null;
                try {
                    File f = new File(cpadds[i]);
                    url = f.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    logger.error("malformed classpath URL {}", url);
                    throw new RuntimeException("invalid classpath entry", e);
                }
                logger.info("adding {} to classpath", (Object)url);
                this.classpathUrls[i] = url;
            }
        }
        if (cmd.hasOption("f")) {
            this.configFile = new File(cmd.getOptionValue("f"));
        }
        this.props = cmd.getOptionProperties("D");
        this.force = cmd.hasOption("F");
        if (cmd.hasOption("j")) {
            String n = cmd.getOptionValue("j");
            this.nthreads = n == null ? 0 : Integer.parseInt(n);
        }
        this.args = cmd.getArgs();
    }

    public static EvalCLIOptions parse(String ... args) {
        CommandLine line;
        GnuParser parser = new GnuParser();
        Options options = EvalCLIOptions.makeOptions();
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            System.exit(1);
            return null;
        }
        if (line.hasOption("h")) {
            HelpFormatter fmt = new HelpFormatter();
            fmt.printHelp("lenskit-eval [OPTIONS] CONFIGS...", options);
            System.exit(1);
            return null;
        }
        if (line.hasOption("v")) {
            System.out.format("lenskit-eval version %s\n", EvalCLIOptions.lenskitVersion());
            System.exit(0);
            return null;
        }
        return new EvalCLIOptions(line);
    }

    public static String lenskitVersion() {
        Properties props = new Properties();
        InputStream stream = EvalCLIOptions.class.getResourceAsStream("/META-INF/lenskit-eval/version.properties");
        try {
            props.load(stream);
        }
        catch (IOException e) {
            throw new RuntimeException("properties error", e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return props.getProperty("lenskit.version");
    }

    private static Options makeOptions() {
        Options opts = new Options();
        OptionBuilder.withDescription((String)"print this help");
        OptionBuilder.withLongOpt((String)"help");
        opts.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.withDescription((String)"print the LensKit version and exit");
        OptionBuilder.withLongOpt((String)"version");
        opts.addOption(OptionBuilder.create((String)"v"));
        OptionBuilder.withDescription((String)"force eval tasks to run");
        OptionBuilder.withLongOpt((String)"force");
        opts.addOption(OptionBuilder.create((String)"F"));
        OptionBuilder.withDescription((String)"number of threads to use");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName((String)"N");
        OptionBuilder.withLongOpt((String)"thread-count");
        opts.addOption(OptionBuilder.create((String)"j"));
        OptionBuilder.withDescription((String)"specify the eval configuration script");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"FILE");
        opts.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.withDescription((String)"add a JAR or directory to the classpath");
        OptionBuilder.withLongOpt((String)"add-to-classpath");
        OptionBuilder.hasArg();
        opts.addOption(OptionBuilder.create((String)"C"));
        OptionBuilder.withDescription((String)"throw exceptions rather than exiting");
        OptionBuilder.withLongOpt((String)"throw-errors");
        opts.addOption(OptionBuilder.create());
        OptionBuilder.withDescription((String)"define a property");
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        opts.addOption(OptionBuilder.create((String)"D"));
        return opts;
    }

    public boolean throwErrors() {
        return Boolean.parseBoolean(System.getProperty("lenskit.eval.throwErrors", "false"));
    }

    public File getScriptFile() {
        return this.configFile;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public String[] getArgs() {
        return this.args;
    }

    public ClassLoader getClassLoader(ClassLoader parent) {
        if (this.classpathUrls == null) {
            return parent;
        }
        return new URLClassLoader(this.classpathUrls, parent);
    }

    public Properties getProperties() {
        Properties ps = new Properties(System.getProperties());
        for (Map.Entry<Object, Object> e : this.props.entrySet()) {
            ps.setProperty((String)e.getKey(), (String)e.getValue());
        }
        if (this.force) {
            ps.setProperty("lenskit.eval.force", "true");
        }
        if (this.nthreads >= 0) {
            ps.setProperty("lenskit.eval.threadCount", Integer.toString(this.nthreads));
        }
        return ps;
    }

    public ClassLoader getClassLoader() {
        return this.getClassLoader(Thread.currentThread().getContextClassLoader());
    }
}

