/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.data;

import org.grouplens.lenskit.data.dao.EventDAO;
import org.grouplens.lenskit.data.dao.ItemDAO;
import org.grouplens.lenskit.data.dao.ItemEventDAO;
import org.grouplens.lenskit.data.dao.PrefetchingItemDAO;
import org.grouplens.lenskit.data.dao.PrefetchingItemEventDAO;
import org.grouplens.lenskit.data.dao.PrefetchingUserDAO;
import org.grouplens.lenskit.data.dao.PrefetchingUserEventDAO;
import org.grouplens.lenskit.data.dao.UserDAO;
import org.grouplens.lenskit.data.dao.UserEventDAO;
import org.grouplens.lenskit.eval.data.DataSource;

public abstract class AbstractDataSource
implements DataSource {
    @Override
    public EventDAO getEventDAO() {
        return (EventDAO)this.getEventDAOProvider().get();
    }

    @Override
    public UserEventDAO getUserEventDAO() {
        EventDAO dao = this.getEventDAO();
        if (dao instanceof UserEventDAO) {
            return (UserEventDAO)dao;
        }
        return new PrefetchingUserEventDAO(dao);
    }

    @Override
    public ItemEventDAO getItemEventDAO() {
        EventDAO dao = this.getEventDAO();
        if (dao instanceof ItemEventDAO) {
            return (ItemEventDAO)dao;
        }
        return new PrefetchingItemEventDAO(dao);
    }

    @Override
    public ItemDAO getItemDAO() {
        EventDAO dao = this.getEventDAO();
        if (dao instanceof ItemDAO) {
            return (ItemDAO)dao;
        }
        return new PrefetchingItemDAO(dao);
    }

    @Override
    public UserDAO getUserDAO() {
        EventDAO dao = this.getEventDAO();
        if (dao instanceof UserDAO) {
            return (UserDAO)dao;
        }
        return new PrefetchingUserDAO(dao);
    }
}

