/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.data;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.inject.Provider;
import org.grouplens.grapht.util.Providers;
import org.grouplens.lenskit.cursors.Cursor;
import org.grouplens.lenskit.cursors.Cursors;
import org.grouplens.lenskit.data.dao.EventCollectionDAO;
import org.grouplens.lenskit.data.dao.EventDAO;
import org.grouplens.lenskit.data.dao.SimpleFileRatingDAO;
import org.grouplens.lenskit.data.event.Rating;
import org.grouplens.lenskit.data.pref.PreferenceDomain;
import org.grouplens.lenskit.eval.data.AbstractDataSource;
import org.grouplens.lenskit.util.SoftMemoizingProvider;
import org.grouplens.lenskit.util.io.CompressionMode;

public class CSVDataSource
extends AbstractDataSource {
    final String name;
    final Provider<EventDAO> provider;
    final File sourceFile;
    final PreferenceDomain domain;
    final String delimiter;

    CSVDataSource(String name, File file, String delim, boolean cache, PreferenceDomain pdom) {
        this.name = name;
        this.sourceFile = file;
        this.domain = pdom;
        this.delimiter = delim;
        SimpleFileRatingDAO fileDao = new SimpleFileRatingDAO(file, delim, CompressionMode.AUTO);
        this.provider = cache ? new SoftMemoizingProvider<EventDAO>((EventDAO)fileDao){
            final /* synthetic */ EventDAO val$fileDao;
            {
                this.val$fileDao = eventDAO;
            }

            @Nonnull
            protected EventDAO newValue() {
                ArrayList ratings = Cursors.makeList((Cursor)this.val$fileDao.streamEvents(Rating.class));
                return new EventCollectionDAO((Collection)ratings);
            }
        } : Providers.of((Object)fileDao);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.sourceFile;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    @Override
    public PreferenceDomain getPreferenceDomain() {
        return this.domain;
    }

    @Override
    public long lastModified() {
        return this.sourceFile.exists() ? this.sourceFile.lastModified() : -1L;
    }

    @Override
    public Provider<EventDAO> getEventDAOProvider() {
        return this.provider;
    }
}

