/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.data;

import com.google.common.base.Preconditions;
import java.io.File;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.Builder;
import org.grouplens.lenskit.data.pref.PreferenceDomain;
import org.grouplens.lenskit.eval.data.CSVDataSource;
import org.grouplens.lenskit.eval.data.DataSource;

public class CSVDataSourceBuilder
implements Builder<DataSource> {
    private String name;
    String delimiter = ",";
    File inputFile;
    boolean cache = true;
    PreferenceDomain domain;

    public CSVDataSourceBuilder() {
    }

    public CSVDataSourceBuilder(String name) {
        this.name = name;
    }

    public CSVDataSourceBuilder(File file) {
        this.inputFile = file;
    }

    public CSVDataSourceBuilder setName(String n) {
        this.name = n;
        return this;
    }

    @Nonnull
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.inputFile.getName();
    }

    public File getFile() {
        return this.inputFile;
    }

    public CSVDataSourceBuilder setFile(File file) {
        this.inputFile = file;
        return this;
    }

    public CSVDataSourceBuilder setFile(String fn) {
        return this.setFile(new File(fn));
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public CSVDataSourceBuilder setDelimiter(String delim) {
        this.delimiter = delim;
        return this;
    }

    public boolean getCache() {
        return this.cache;
    }

    public CSVDataSourceBuilder setCache(boolean on) {
        this.cache = on;
        return this;
    }

    public PreferenceDomain getDomain() {
        return this.domain;
    }

    public CSVDataSourceBuilder setDomain(PreferenceDomain dom) {
        this.domain = dom;
        return this;
    }

    public CSVDataSource build() {
        if (this.name == null && this.inputFile != null) {
            this.setName(this.inputFile.toString());
        }
        if (this.inputFile == null && this.name != null) {
            this.inputFile = new File(this.getName());
        }
        Preconditions.checkState((this.inputFile != null ? 1 : 0) != 0, (Object)"no input file specified");
        return new CSVDataSource(this.getName(), this.inputFile, this.delimiter, this.cache, this.domain);
    }
}

