/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.data.crossfold;

import java.util.List;
import java.util.Random;
import org.grouplens.lenskit.data.event.Rating;
import org.grouplens.lenskit.eval.data.crossfold.Order;
import org.grouplens.lenskit.eval.data.crossfold.PartitionAlgorithm;

public class Holdout {
    private final Order<Rating> order;
    private final PartitionAlgorithm<Rating> partitionMethod;

    public Holdout(Order<Rating> ord, PartitionAlgorithm<Rating> part) {
        this.order = ord;
        this.partitionMethod = part;
    }

    public Order<Rating> getOrder() {
        return this.order;
    }

    public PartitionAlgorithm<Rating> getPartitionMethod() {
        return this.partitionMethod;
    }

    public int partition(List<Rating> ratings, Random rng) {
        if (this.order == null || this.partitionMethod == null) {
            throw new IllegalStateException("Unconfigured holdout");
        }
        this.order.apply(ratings, rng);
        return this.partitionMethod.partition(ratings);
    }
}

