/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.data.subsample;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongLists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.grouplens.lenskit.cursors.Cursor;
import org.grouplens.lenskit.cursors.Cursors;
import org.grouplens.lenskit.data.dao.ItemDAO;
import org.grouplens.lenskit.data.dao.ItemEventDAO;
import org.grouplens.lenskit.data.dao.UserDAO;
import org.grouplens.lenskit.data.dao.UserEventDAO;
import org.grouplens.lenskit.data.event.Rating;
import org.grouplens.lenskit.data.history.UserHistory;
import org.grouplens.lenskit.data.pref.Preference;
import org.grouplens.lenskit.eval.data.DataSource;
import org.grouplens.lenskit.util.table.writer.TableWriter;

public enum SubsampleMode {
    RATING{

        @Override
        public void doSample(DataSource source, TableWriter output, double fraction, Random rng) throws IOException {
            ArrayList ratings = Cursors.makeList((Cursor)source.getEventDAO().streamEvents(Rating.class));
            int n = ratings.size();
            int m = (int)(fraction * (double)n);
            for (int i = 0; i < m; ++i) {
                int j = rng.nextInt(n - 1 - i) + i;
                Rating rating = (Rating)ratings.get(j);
                ratings.set(j, ratings.get(i));
                SubsampleMode.writeRating(output, rating);
            }
        }
    }
    ,
    ITEM{

        @Override
        public void doSample(DataSource source, TableWriter output, double fraction, Random rng) throws IOException {
            ItemDAO idao = source.getItemDAO();
            ItemEventDAO edao = source.getItemEventDAO();
            LongArrayList itemList = new LongArrayList((LongCollection)idao.getItemIds());
            LongLists.shuffle((LongList)itemList, (Random)rng);
            int n = itemList.size();
            int m = (int)(fraction * (double)n);
            LongListIterator iter = itemList.subList(0, m).iterator();
            while (iter.hasNext()) {
                long item = iter.nextLong();
                List events = edao.getEventsForItem(item, Rating.class);
                for (Rating rating : events) {
                    SubsampleMode.writeRating(output, rating);
                }
            }
        }
    }
    ,
    USER{

        @Override
        public void doSample(DataSource source, TableWriter output, double fraction, Random rng) throws IOException {
            UserDAO udao = source.getUserDAO();
            UserEventDAO edao = source.getUserEventDAO();
            LongArrayList userList = new LongArrayList((LongCollection)udao.getUserIds());
            LongLists.shuffle((LongList)userList, (Random)rng);
            int n = userList.size();
            int m = (int)(fraction * (double)n);
            LongListIterator iter = userList.subList(0, m).iterator();
            while (iter.hasNext()) {
                long user = iter.nextLong();
                UserHistory events = edao.getEventsForUser(user, Rating.class);
                for (Rating rating : events) {
                    SubsampleMode.writeRating(output, rating);
                }
            }
        }
    };


    public abstract void doSample(DataSource var1, TableWriter var2, double var3, Random var5) throws IOException;

    private static void writeRating(TableWriter output, Rating rating) throws IOException {
        Preference pref;
        Object[] row = new String[]{Long.toString(rating.getUserId()), Long.toString(rating.getItemId()), (pref = rating.getPreference()) != null ? Double.toString(pref.getValue()) : "NaN", Long.toString(rating.getTimestamp())};
        output.writeRow(row);
    }
}

