/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.data.subsample;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.grouplens.lenskit.eval.AbstractTask;
import org.grouplens.lenskit.eval.TaskExecutionException;
import org.grouplens.lenskit.eval.data.CSVDataSourceBuilder;
import org.grouplens.lenskit.eval.data.DataSource;
import org.grouplens.lenskit.eval.data.subsample.SubsampleMode;
import org.grouplens.lenskit.util.io.UpToDateChecker;
import org.grouplens.lenskit.util.table.writer.CSVWriter;
import org.grouplens.lenskit.util.table.writer.TableWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubsampleTask
extends AbstractTask<DataSource> {
    private static final Logger logger = LoggerFactory.getLogger(SubsampleTask.class);
    private DataSource source;
    private double subsampleFraction = 0.1;
    private SubsampleMode mode = SubsampleMode.RATING;
    @Nullable
    private File output;

    public SubsampleTask() {
        super("subsample");
    }

    public SubsampleTask(String name) {
        super(name);
    }

    public SubsampleTask setFraction(double fraction) throws IllegalArgumentException {
        if (!(fraction >= 0.0) || !(fraction <= 1.0)) {
            String msg = String.format("fraction %f not in range [0,1]", fraction);
            throw new IllegalArgumentException(msg);
        }
        this.subsampleFraction = fraction;
        return this;
    }

    public SubsampleTask setOutput(String name) {
        return this.setOutput(new File(name));
    }

    public SubsampleTask setOutput(File out) {
        this.output = out;
        return this;
    }

    public SubsampleTask setSource(DataSource source) {
        this.source = source;
        return this;
    }

    public SubsampleTask setMode(SubsampleMode mode) {
        this.mode = mode;
        return this;
    }

    public File getOutput() {
        if (this.output == null) {
            return new File(this.getName() + ".subsample.csv");
        }
        return this.output;
    }

    public DataSource getSource() {
        return this.source;
    }

    public double getFraction() {
        return this.subsampleFraction;
    }

    public SubsampleMode getMode() {
        return this.mode;
    }

    private DataSource makeDataSource() {
        CSVDataSourceBuilder bld = new CSVDataSourceBuilder().setDomain(this.source.getPreferenceDomain()).setFile(this.getOutput());
        return bld.build();
    }

    @Override
    public DataSource perform() throws TaskExecutionException {
        UpToDateChecker check = new UpToDateChecker();
        check.addInput(this.source.lastModified());
        File subsampleFile = this.getOutput();
        check.addOutput(subsampleFile);
        if (check.isUpToDate()) {
            logger.info("subsample {} up to date", (Object)this.getName());
            return this.makeDataSource();
        }
        try {
            logger.info("sampling {} of {}", (Object)this.subsampleFraction, (Object)this.source.getName());
            Closer closer = Closer.create();
            TableWriter subsampleWriter = (TableWriter)closer.register((Closeable)CSVWriter.open(subsampleFile, null));
            try {
                this.mode.doSample(this.source, subsampleWriter, this.subsampleFraction, this.getProject().getRandom());
            }
            catch (Throwable th) {
                throw closer.rethrow(th);
            }
            finally {
                closer.close();
            }
        }
        catch (IOException e) {
            throw new TaskExecutionException("Error writing output file", e);
        }
        return this.makeDataSource();
    }
}

