/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.data.traintest;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.Builder;
import org.grouplens.lenskit.eval.data.DataSource;
import org.grouplens.lenskit.eval.data.traintest.GenericTTDataSet;

public class GenericTTDataBuilder
implements Builder<GenericTTDataSet> {
    private String name;
    private DataSource trainingData;
    private DataSource testData;
    private Map<String, Object> attributes = new LinkedHashMap<String, Object>();

    public GenericTTDataBuilder() {
        this(null);
    }

    public GenericTTDataBuilder(String name) {
        this.name = name;
    }

    public GenericTTDataBuilder setName(String n) {
        this.name = n;
        return this;
    }

    public GenericTTDataBuilder setTrain(DataSource ds) {
        this.trainingData = ds;
        return this;
    }

    public GenericTTDataBuilder setTest(DataSource ds) {
        this.testData = ds;
        return this;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.trainingData.getName();
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public GenericTTDataBuilder setAttribute(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }

    public GenericTTDataSet build() {
        if (this.attributes.isEmpty()) {
            this.attributes.put("DataSet", this.getName());
        }
        Preconditions.checkNotNull((Object)this.trainingData, (Object)"train data is Null");
        return new GenericTTDataSet(this.getName(), this.trainingData, this.testData, this.trainingData.getPreferenceDomain(), this.attributes);
    }
}

