/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.data.traintest;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.grouplens.lenskit.data.dao.EventDAO;
import org.grouplens.lenskit.data.pref.PreferenceDomain;
import org.grouplens.lenskit.eval.data.DataSource;
import org.grouplens.lenskit.eval.data.GenericDataSource;
import org.grouplens.lenskit.eval.data.traintest.TTDataSet;

public class GenericTTDataSet
implements TTDataSet {
    @Nonnull
    private final String name;
    @Nonnull
    private final DataSource trainData;
    @Nonnull
    private final DataSource testData;
    @Nullable
    private final PreferenceDomain preferenceDomain;
    private final Map<String, Object> attributes;

    public GenericTTDataSet(@Nonnull String name, @Nonnull DataSource train, @Nonnull DataSource test, @Nullable PreferenceDomain dom, Map<String, Object> attrs) {
        Preconditions.checkNotNull((Object)train, (Object)"no training data");
        Preconditions.checkNotNull((Object)test, (Object)"no test data");
        this.name = name;
        this.trainData = train;
        this.testData = test;
        this.preferenceDomain = dom;
        this.attributes = attrs == null ? Collections.emptyMap() : Maps.newHashMap(attrs);
    }

    public GenericTTDataSet(@Nonnull String name, @Nonnull Provider<EventDAO> train, @Nonnull Provider<EventDAO> test, @Nullable PreferenceDomain domain) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(train);
        Preconditions.checkNotNull(test);
        this.name = name;
        this.trainData = new GenericDataSource(name + ".train", train, domain);
        this.testData = new GenericDataSource(name + ".test", test, domain);
        this.preferenceDomain = domain;
        this.attributes = Collections.singletonMap("DataSet", name);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public long lastModified() {
        return Math.max(this.trainData.lastModified(), this.testData.lastModified());
    }

    @Override
    public void release() {
    }

    @Override
    @Nullable
    public PreferenceDomain getPreferenceDomain() {
        return this.preferenceDomain;
    }

    @Override
    public EventDAO getTrainingDAO() {
        return this.trainData.getEventDAO();
    }

    @Override
    public EventDAO getTestDAO() {
        return this.testData.getEventDAO();
    }

    @Override
    @Nonnull
    public DataSource getTestData() {
        return this.testData;
    }

    @Override
    @Nonnull
    public DataSource getTrainingData() {
        return this.trainData;
    }

    public String toString() {
        return String.format("{TTDataSet %s}", this.name);
    }
}

