/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.graph;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.Builder;
import org.grouplens.grapht.spi.Desire;
import org.grouplens.lenskit.eval.graph.GVNode;
import org.grouplens.lenskit.eval.graph.HTMLLabel;
import org.grouplens.lenskit.eval.graph.NodeBuilder;

class ComponentNodeBuilder
implements Builder<GVNode> {
    static final String SHAREABLE_BGCOLOR = "#4e9a06";
    static final String SHAREABLE_UNSHARED_BGCOLOR = "#a40000";
    static final String UNSHARED_BGCOLOR = "#2e3436";
    static final String TYPE_COLOR = "white";
    static final String SHARED_COLOR = "#555753";
    static final String UNSHARED_COLOR = "black";
    private final String nodeId;
    private final String label;
    private final List<String> dependencies = new ArrayList<String>();
    private final List<String> parameters = new ArrayList<String>();
    private boolean shareable = false;
    private boolean isShared = false;
    private boolean isProvider = false;
    private boolean isProvided = false;
    private boolean isInterface = false;
    private static final Pattern ANNOT_PATTERN = Pattern.compile("@[^(]+\\((.*)\\)");

    private ComponentNodeBuilder(String id, Class<?> type) {
        this.nodeId = id;
        this.label = ComponentNodeBuilder.shortClassName(type);
        this.isInterface = type.isInterface();
    }

    public static ComponentNodeBuilder create(String id, Class<?> type) {
        return new ComponentNodeBuilder(id, type);
    }

    public ComponentNodeBuilder addDependency(Desire dep) {
        Annotation q = dep.getInjectionPoint().getAttributes().getQualifier();
        Class type = dep.getDesiredType();
        if (q == null) {
            this.dependencies.add(ComponentNodeBuilder.shortClassName(type));
        } else {
            this.dependencies.add(ComponentNodeBuilder.shortAnnotation(q) + ": " + ComponentNodeBuilder.shortClassName(type));
        }
        return this;
    }

    public ComponentNodeBuilder addParameter(Annotation param, Object value) {
        StringBuilder lbl = new StringBuilder();
        lbl.append(ComponentNodeBuilder.shortAnnotation(param)).append(": ");
        if (value instanceof String) {
            lbl.append('\"').append(StringEscapeUtils.escapeJava((String)value.toString())).append('\"');
        } else {
            lbl.append(value);
        }
        this.parameters.add(lbl.toString());
        return this;
    }

    public int getLastDependencyPort() {
        if (this.dependencies.isEmpty()) {
            throw new IllegalStateException("dependency list is empty");
        }
        return this.dependencies.size();
    }

    public ComponentNodeBuilder setShareable(boolean yn) {
        this.shareable = yn;
        return this;
    }

    public ComponentNodeBuilder setShared(boolean yn) {
        this.isShared = yn;
        return this;
    }

    public ComponentNodeBuilder setIsProvider(boolean yn) {
        this.isProvider = yn;
        return this;
    }

    public ComponentNodeBuilder setIsProvided(boolean yn) {
        this.isProvided = yn;
        return this;
    }

    private String fillColor() {
        if (this.shareable) {
            if (this.isShared) {
                return SHAREABLE_BGCOLOR;
            }
            return SHAREABLE_UNSHARED_BGCOLOR;
        }
        return UNSHARED_BGCOLOR;
    }

    public GVNode build() {
        NodeBuilder nb = NodeBuilder.create(this.nodeId);
        if (this.dependencies.isEmpty() && this.parameters.isEmpty()) {
            nb.setLabel(this.label).setShape("box").set("fillcolor", this.fillColor()).set("fontcolor", TYPE_COLOR).set("color", UNSHARED_BGCOLOR).add("style", "filled");
        } else {
            StringBuilder lbl = new StringBuilder();
            lbl.append("<TABLE").append(" CELLSPACING=\"0\"").append(" BORDER=\"1\"").append(" STYLE=\"ROUNDED\"").append(" ROWS=\"*\"").append(" COLOR=\"").append(UNSHARED_BGCOLOR).append("\"").append(">");
            lbl.append("<TR><TD PORT=\"H\" ALIGN=\"CENTER\" BORDER=\"2\"").append(" BGCOLOR=\"").append(this.fillColor()).append("\"");
            lbl.append(">").append("<FONT COLOR=\"").append(TYPE_COLOR).append("\">").append("<B>").append(StringEscapeUtils.escapeHtml4((String)this.label)).append("</B>").append("</FONT>").append("</TD></TR>");
            int i = 1;
            for (String dep : this.dependencies) {
                lbl.append("<TR><TD BORDER=\"1\" PORT=\"").append(i++).append("\" ALIGN=\"LEFT\">").append(StringEscapeUtils.escapeHtml4((String)dep)).append("</TD></TR>");
            }
            for (String param : this.parameters) {
                lbl.append("<TR><TD ALIGN=\"LEFT\"");
                lbl.append(">").append(StringEscapeUtils.escapeHtml4((String)param)).append("</TD></TR>");
            }
            lbl.append("</TABLE>");
            nb.setLabel(new HTMLLabel(lbl.toString())).setTarget(this.nodeId + ":H").setShape("plaintext").set("margin", 0);
        }
        return nb.build();
    }

    static String shortClassName(Class<?> type) {
        if (ClassUtils.isPrimitiveOrWrapper(type)) {
            if (!type.isPrimitive()) {
                type = ClassUtils.wrapperToPrimitive(type);
            }
            return type.getName();
        }
        if (type.getPackage().equals(Package.getPackage("java.lang"))) {
            return type.getSimpleName();
        }
        String[] words = type.getName().split(" ");
        String fullClassName = words[words.length - 1];
        Object[] path = fullClassName.split("\\.");
        int i = 0;
        while (!Character.isUpperCase(path[i + 1].charAt(0))) {
            path[i] = ((String)path[i]).substring(0, 1);
            ++i;
        }
        return StringUtils.join((Object[])path, (String)".");
    }

    static String shortAnnotation(Annotation annot) {
        Matcher m = ANNOT_PATTERN.matcher(annot.toString());
        if (m.matches()) {
            StringBuilder bld = new StringBuilder();
            bld.append('@');
            bld.append(ComponentNodeBuilder.shortClassName(annot.annotationType()));
            String values = m.group(1);
            if (!values.isEmpty()) {
                bld.append('(');
                bld.append(values);
                bld.append(')');
            }
            return bld.toString();
        }
        throw new RuntimeException("invalid annotation string format");
    }
}

