/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.graph;

import com.google.common.io.Closer;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nonnull;
import org.grouplens.grapht.graph.Edge;
import org.grouplens.grapht.graph.Graph;
import org.grouplens.grapht.graph.Node;
import org.grouplens.grapht.spi.AbstractSatisfactionVisitor;
import org.grouplens.grapht.spi.CachedSatisfaction;
import org.grouplens.grapht.spi.Satisfaction;
import org.grouplens.grapht.spi.SatisfactionVisitor;
import org.grouplens.grapht.util.Providers;
import org.grouplens.lenskit.core.LenskitConfiguration;
import org.grouplens.lenskit.core.RecommenderConfigurationException;
import org.grouplens.lenskit.core.RecommenderInstantiator;
import org.grouplens.lenskit.data.dao.EventDAO;
import org.grouplens.lenskit.data.pref.PreferenceDomain;
import org.grouplens.lenskit.eval.AbstractTask;
import org.grouplens.lenskit.eval.TaskExecutionException;
import org.grouplens.lenskit.eval.algorithm.LenskitAlgorithmInstance;
import org.grouplens.lenskit.eval.graph.EdgeBuilder;
import org.grouplens.lenskit.eval.graph.GraphDumper;
import org.grouplens.lenskit.eval.graph.GraphWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumpGraphTask
extends AbstractTask<File> {
    private static final Logger logger = LoggerFactory.getLogger(DumpGraphTask.class);
    private LenskitAlgorithmInstance algorithm;
    private File output;
    private PreferenceDomain domain = null;

    public DumpGraphTask() {
        this(null);
    }

    public DumpGraphTask(String name) {
        super(name);
    }

    @Override
    @Nonnull
    public String getName() {
        String name = super.getName();
        if (name == null && (name = this.algorithm.getName()) == null) {
            name = "algorithm";
        }
        return name;
    }

    public LenskitAlgorithmInstance getAlgorithm() {
        return this.algorithm;
    }

    public DumpGraphTask setAlgorithm(LenskitAlgorithmInstance algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public File getOutput() {
        return this.output;
    }

    public DumpGraphTask setOutput(File f) {
        this.output = f;
        return this;
    }

    public DumpGraphTask setOutput(String fn) {
        return this.setOutput(new File(fn));
    }

    public PreferenceDomain getDomain() {
        return this.domain;
    }

    public DumpGraphTask setDomain(PreferenceDomain dom) {
        this.domain = dom;
        return this;
    }

    @Override
    public File perform() throws TaskExecutionException {
        RecommenderInstantiator instantiator;
        if (this.output == null) {
            logger.error("no output file specified");
            throw new IllegalStateException("no graph output file specified");
        }
        LenskitConfiguration config = this.algorithm.getConfig().copy();
        config.bind(EventDAO.class).toProvider(Providers.of(null, EventDAO.class));
        if (this.domain != null) {
            config.bind(PreferenceDomain.class).to((Object)this.domain);
        }
        logger.info("dumping graph {}", (Object)this.getName());
        try {
            instantiator = RecommenderInstantiator.forConfig((LenskitConfiguration)config);
        }
        catch (RecommenderConfigurationException e) {
            throw new TaskExecutionException("error resolving algorithm configuration", e);
        }
        Graph initial = instantiator.getGraph();
        logger.debug("graph has {} nodes", (Object)initial.getNodes().size());
        Graph unshared = instantiator.simulate();
        logger.debug("unshared graph has {} nodes", (Object)unshared.getNodes().size());
        try {
            this.writeGraph(initial, unshared.getNodes(), this.output);
        }
        catch (IOException e) {
            throw new TaskExecutionException("error writing graph", e);
        }
        return this.output;
    }

    private void writeGraph(Graph g, Set<Node> unshared, File file) throws IOException, TaskExecutionException {
        Files.createParentDirs((File)this.output);
        Closer close = Closer.create();
        try {
            FileWriter writer = (FileWriter)close.register((Closeable)new FileWriter(file));
            GraphWriter gw = (GraphWriter)close.register((Closeable)new GraphWriter(writer));
            this.renderGraph(g, unshared, gw);
        }
        catch (Throwable th) {
            throw close.rethrow(th, TaskExecutionException.class);
        }
        finally {
            close.close();
        }
    }

    private void renderGraph(Graph g, Set<Node> unshared, GraphWriter gw) throws TaskExecutionException {
        Node root = g.getNode(null);
        if (root == null) {
            throw new TaskExecutionException("no root node for graph");
        }
        GraphDumper dumper = new GraphDumper(g, unshared, gw);
        try {
            String rid = dumper.setRoot(root);
            for (Edge e : g.getOutgoingEdges(root)) {
                Node target = e.getTail();
                CachedSatisfaction csat = target.getLabel();
                assert (csat != null);
                if (this.satIsNull(csat.getSatisfaction())) continue;
                String id = dumper.process(target);
                gw.putEdge(EdgeBuilder.create(rid, id).set("arrowhead", "vee").build());
            }
            dumper.finish();
        }
        catch (IOException e) {
            throw new TaskExecutionException("error writing graph", e);
        }
    }

    private boolean satIsNull(Satisfaction sat) {
        return (Boolean)sat.visit((SatisfactionVisitor)new AbstractSatisfactionVisitor<Boolean>(Boolean.valueOf(false)){

            public Boolean visitNull() {
                return true;
            }
        });
    }
}

