/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.graph;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.Builder;
import org.grouplens.lenskit.eval.graph.GVEdge;

class EdgeBuilder
implements Builder<GVEdge> {
    private String srcId;
    private String tgtId;
    private final Map<String, Object> attributes;

    private EdgeBuilder(String src, String tgt) {
        Preconditions.checkNotNull((Object)src, (Object)"source ID must not be null");
        Preconditions.checkNotNull((Object)tgt, (Object)"target ID must not be null");
        this.srcId = src;
        this.tgtId = tgt;
        this.attributes = new LinkedHashMap<String, Object>();
    }

    private EdgeBuilder(String src, String tgt, Map<String, Object> attrs) {
        this.srcId = src;
        this.tgtId = tgt;
        this.attributes = new LinkedHashMap<String, Object>(attrs);
    }

    public static EdgeBuilder create(String src, String tgt) {
        return new EdgeBuilder(src, tgt);
    }

    public static EdgeBuilder of(GVEdge edge) {
        return new EdgeBuilder(edge.getSource(), edge.getTarget(), edge.getAttributes());
    }

    public EdgeBuilder set(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }

    public EdgeBuilder setSource(String src) {
        Preconditions.checkNotNull((Object)src, (Object)"source ID must not be null");
        this.srcId = src;
        return this;
    }

    public EdgeBuilder setTarget(String tgt) {
        Preconditions.checkNotNull((Object)tgt, (Object)"target ID must not be null");
        this.tgtId = tgt;
        return this;
    }

    public GVEdge build() {
        return new GVEdge(this.srcId, this.tgtId, this.attributes);
    }
}

