/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.graph;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.apache.commons.lang3.tuple.Pair;
import org.grouplens.grapht.graph.Edge;
import org.grouplens.grapht.graph.Graph;
import org.grouplens.grapht.graph.Node;
import org.grouplens.grapht.spi.AbstractSatisfactionVisitor;
import org.grouplens.grapht.spi.CachedSatisfaction;
import org.grouplens.grapht.spi.Desire;
import org.grouplens.grapht.spi.InjectionPoint;
import org.grouplens.grapht.spi.Satisfaction;
import org.grouplens.grapht.spi.SatisfactionVisitor;
import org.grouplens.grapht.spi.reflect.ConstructorParameterInjectionPoint;
import org.grouplens.grapht.spi.reflect.FieldInjectionPoint;
import org.grouplens.grapht.spi.reflect.NoArgumentInjectionPoint;
import org.grouplens.grapht.spi.reflect.SetterInjectionPoint;
import org.grouplens.grapht.spi.reflect.SimpleInjectionPoint;
import org.grouplens.lenskit.core.GraphtUtils;
import org.grouplens.lenskit.core.Parameter;
import org.grouplens.lenskit.eval.graph.ComponentNodeBuilder;
import org.grouplens.lenskit.eval.graph.EdgeBuilder;
import org.grouplens.lenskit.eval.graph.GVEdge;
import org.grouplens.lenskit.eval.graph.GVNode;
import org.grouplens.lenskit.eval.graph.GraphWriter;
import org.grouplens.lenskit.eval.graph.NodeBuilder;
import org.grouplens.lenskit.eval.graph.SubgraphBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GraphDumper {
    private static final Logger logger = LoggerFactory.getLogger(GraphDumper.class);
    private static final String ROOT_ID = "root";
    private final GraphWriter writer;
    private final Graph graph;
    private final Set<Node> unsharedNodes;
    private final Map<Node, String> nodeIds;
    private final Map<String, String> nodeTargets;
    private final Queue<GVEdge> edgeQueue;
    private static Function<Edge, List<String>> ORDER_KEY = new Function<Edge, List<String>>(){

        @Nullable
        public List<String> apply(@Nullable Edge input) {
            if (input == null) {
                throw new IllegalArgumentException("cannot order null edge");
            }
            Desire desire = input.getDesire();
            if (desire == null) {
                throw new IllegalArgumentException("cannot order null desire");
            }
            InjectionPoint ip = desire.getInjectionPoint();
            ArrayList<String> key = new ArrayList<String>(4);
            if (ip instanceof ConstructorParameterInjectionPoint) {
                ConstructorParameterInjectionPoint cpi = (ConstructorParameterInjectionPoint)ip;
                key.add("0: constructor");
                key.add(Integer.toString(cpi.getParameterIndex()));
            } else if (ip instanceof SetterInjectionPoint) {
                SetterInjectionPoint spi = (SetterInjectionPoint)ip;
                key.add("1: setter");
                key.add(spi.getMember().getName());
                key.add(Integer.toString(spi.getParameterIndex()));
            } else if (ip instanceof FieldInjectionPoint) {
                FieldInjectionPoint fpi = (FieldInjectionPoint)ip;
                key.add("2: field");
                key.add(fpi.getMember().getName());
            } else if (ip instanceof NoArgumentInjectionPoint) {
                NoArgumentInjectionPoint fpi = (NoArgumentInjectionPoint)ip;
                key.add("8: no-arg");
                key.add(fpi.getMember().getName());
            } else if (ip instanceof SimpleInjectionPoint) {
                key.add("5: simple");
            } else {
                key.add("9: unknown");
                key.add(ip.getClass().getName());
            }
            return key;
        }
    };
    private static Ordering<Edge> EDGE_ORDER = Ordering.natural().lexicographical().onResultOf(ORDER_KEY);

    public GraphDumper(Graph g, Set<Node> unshared, GraphWriter gw) {
        this.writer = gw;
        this.graph = g;
        this.unsharedNodes = new HashSet<Node>(unshared);
        this.unsharedNodes.retainAll(g.getNodes());
        logger.debug("{} shared nodes", (Object)this.unsharedNodes.size());
        this.nodeIds = new HashMap<Node, String>();
        this.nodeTargets = new HashMap<String, String>();
        this.edgeQueue = new LinkedList<GVEdge>();
    }

    public String setRoot(Node root) throws IOException {
        if (!this.nodeTargets.isEmpty()) {
            throw new IllegalStateException("root node already specificied");
        }
        this.nodeIds.put(root, ROOT_ID);
        this.nodeTargets.put(ROOT_ID, ROOT_ID);
        this.writer.putNode(NodeBuilder.create(ROOT_ID).setLabel(ROOT_ID).setShape("box").add("style", "rounded").build());
        return ROOT_ID;
    }

    public String process(Node node) throws IOException {
        String tgt;
        Preconditions.checkNotNull((Object)node, (Object)"node must not be null");
        if (this.nodeTargets.isEmpty()) {
            throw new IllegalStateException("root node has not been set");
        }
        String id = this.nodeIds.get(node);
        if (id == null) {
            id = "N" + this.nodeIds.size();
            this.nodeIds.put(node, id);
            CachedSatisfaction csat = node.getLabel();
            assert (csat != null);
            Satisfaction sat = csat.getSatisfaction();
            try {
                tgt = (String)sat.visit((SatisfactionVisitor)new Visitor(node, id));
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
            Preconditions.checkNotNull((Object)tgt, (Object)"the returned target was null");
            this.nodeTargets.put(id, tgt);
        } else {
            tgt = this.nodeTargets.get(id);
            if (tgt == null) {
                tgt = id;
            }
        }
        return tgt;
    }

    public void finish() throws IOException {
        while (!this.edgeQueue.isEmpty()) {
            GVEdge e = this.edgeQueue.remove();
            String newTarget = this.nodeTargets.get(e.getTarget());
            if (newTarget != null) {
                e = EdgeBuilder.of(e).setTarget(newTarget).build();
            }
            this.writer.putEdge(e);
        }
    }

    private class Visitor
    implements SatisfactionVisitor<String> {
        private final Node currentNode;
        private final String nodeId;
        private final Satisfaction satisfaction;

        private Visitor(Node nd, String id) {
            this.currentNode = nd;
            this.nodeId = id;
            if (this.currentNode == null) {
                throw new IllegalStateException("dumper not running");
            }
            CachedSatisfaction csat = this.currentNode.getLabel();
            assert (csat != null);
            this.satisfaction = csat.getSatisfaction();
        }

        public String visitNull() {
            NodeBuilder nb = NodeBuilder.create(this.nodeId);
            nb.setShape("ellipse");
            nb.setLabel("null");
            GVNode node = nb.build();
            try {
                GraphDumper.this.writer.putNode(node);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            return node.getTarget();
        }

        public String visitClass(Class<?> clazz) {
            GVNode node = this.componentNode(clazz, null);
            try {
                GraphDumper.this.writer.putNode(node);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            return node.getTarget();
        }

        public String visitInstance(Object instance) {
            GVNode node = NodeBuilder.create(this.nodeId).setLabel(instance.toString()).setShape("ellipse").build();
            try {
                GraphDumper.this.writer.putNode(node);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            return node.getId();
        }

        private Pair<GVNode, GVEdge> providedNode(String pid) {
            GVNode pNode = ComponentNodeBuilder.create(this.nodeId, this.satisfaction.getErasedType()).setShareable(GraphtUtils.isShareable((Node)this.currentNode)).setShared(!GraphDumper.this.unsharedNodes.contains(this.currentNode)).setIsProvided(true).build();
            GVEdge pEdge = EdgeBuilder.create(pNode.getTarget() + ":e", pid).set("style", "dotted").set("dir", "back").set("arrowhead", "vee").build();
            return Pair.of((Object)pNode, (Object)pEdge);
        }

        public String visitProviderClass(Class<? extends Provider<?>> pclass) {
            String pid = this.nodeId + "P";
            GVNode pnode = this.componentNode(pclass, pid);
            Pair<GVNode, GVEdge> provided = this.providedNode(pid);
            try {
                SubgraphBuilder sgb = new SubgraphBuilder();
                GraphDumper.this.writer.putSubgraph(sgb.setName("sgp_" + pid).addNode(pnode).addNode((GVNode)provided.getLeft()).addEdge((GVEdge)provided.getRight()).build());
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            return ((GVNode)provided.getLeft()).getTarget();
        }

        public String visitProviderInstance(Provider<?> provider) {
            String pid = this.nodeId + "P";
            GVNode pnode = NodeBuilder.create(pid).setLabel(provider.toString()).setShape("ellipse").set("style", "dashed").build();
            Pair<GVNode, GVEdge> provided = this.providedNode(pid);
            try {
                SubgraphBuilder sgb = new SubgraphBuilder();
                GraphDumper.this.writer.putSubgraph(sgb.setName("sgp_" + pid).addNode(pnode).addNode((GVNode)provided.getLeft()).addEdge((GVEdge)provided.getRight()).build());
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            return ((GVNode)provided.getLeft()).getTarget();
        }

        private GVNode componentNode(Class<?> type, String pid) {
            String id = pid == null ? this.nodeId : pid;
            ComponentNodeBuilder bld = ComponentNodeBuilder.create(id, type);
            bld.setShareable(pid == null && GraphtUtils.isShareable((Node)this.currentNode)).setShared(!GraphDumper.this.unsharedNodes.contains(this.currentNode)).setIsProvider(pid != null);
            ArrayList edges = Lists.newArrayList((Iterable)GraphDumper.this.graph.getOutgoingEdges(this.currentNode));
            Collections.sort(edges, EDGE_ORDER);
            for (Edge e : edges) {
                Desire dep = e.getDesire();
                assert (dep != null);
                Annotation q = dep.getInjectionPoint().getAttributes().getQualifier();
                Node targetNode = e.getTail();
                if (q != null && q.annotationType().getAnnotation(Parameter.class) != null) {
                    logger.debug("dumping parameter {}", (Object)q);
                    CachedSatisfaction tcsat = targetNode.getLabel();
                    assert (tcsat != null);
                    Satisfaction tsat = tcsat.getSatisfaction();
                    Object val = tsat.visit((SatisfactionVisitor)new AbstractSatisfactionVisitor<Object>(null){

                        public Object visitInstance(Object instance) {
                            return instance;
                        }
                    });
                    if (val == null) {
                        logger.warn("parameter {} not bound", (Object)q);
                    }
                    bld.addParameter(q, val);
                    continue;
                }
                logger.debug("dumping dependency {}", (Object)dep);
                bld.addDependency(dep);
                String tid = null;
                try {
                    tid = GraphDumper.this.process(targetNode);
                }
                catch (IOException exc) {
                    throw Throwables.propagate((Throwable)exc);
                }
                String port = String.format("%s:%d", id, bld.getLastDependencyPort());
                EdgeBuilder eb = EdgeBuilder.create(port, tid).set("arrowhead", "vee");
                if (GraphtUtils.desireIsTransient((Desire)dep)) {
                    eb.set("style", "dashed");
                }
                GraphDumper.this.edgeQueue.add(eb.build());
            }
            GVNode node = bld.build();
            return node;
        }
    }
}

