/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.graph;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringEscapeUtils;
import org.grouplens.lenskit.eval.graph.GVEdge;
import org.grouplens.lenskit.eval.graph.GVNode;
import org.grouplens.lenskit.eval.graph.GVSubgraph;
import org.grouplens.lenskit.eval.graph.HTMLLabel;

class GraphWriter
implements Closeable {
    private static final Pattern SAFE_VALUE = Pattern.compile("\\w+");
    private final BufferedWriter output;

    public GraphWriter(Writer out) throws IOException {
        this.output = new BufferedWriter(out);
        this.output.append("digraph {\n");
        this.output.append("  node [fontname=\"Helvetica\"").append(",color=\"").append("#2e3436").append("\"").append("];\n");
        this.output.append("  graph [rankdir=LR];\n");
        this.output.append("  edge [").append("color=\"").append("#2e3436").append("\"").append("];\n");
    }

    @Override
    public void close() throws IOException {
        this.output.write("}\n");
        this.output.close();
    }

    private String safeValue(Object obj) {
        String str = obj.toString();
        if (obj instanceof HTMLLabel || SAFE_VALUE.matcher(str).matches()) {
            return str;
        }
        return "\"" + StringEscapeUtils.escapeJava((String)str) + "\"";
    }

    private void putAttributes(Map<String, Object> attrs) throws IOException {
        if (!attrs.isEmpty()) {
            this.output.append(" [");
            Joiner.on((String)", ").withKeyValueSeparator("=").appendTo((Appendable)this.output, Maps.transformValues(attrs, (Function)new Function<Object, String>(){

                @Nullable
                public String apply(@Nullable Object input) {
                    return GraphWriter.this.safeValue(input);
                }
            }));
            this.output.append("]");
        }
    }

    public void putNode(GVNode node) throws IOException {
        String id = node.getId();
        this.output.append("  ").append(id);
        this.putAttributes(node.getAttributes());
        this.output.append(";\n");
    }

    public void putEdge(GVEdge edge) throws IOException {
        String src = edge.getSource();
        String dst = edge.getTarget();
        this.output.append("  ").append(src).append(" -> ").append(dst);
        this.putAttributes(edge.getAttributes());
        this.output.append(";\n");
    }

    public void putSubgraph(GVSubgraph subgraph) throws IOException {
        this.output.append("  subgraph ");
        String name = subgraph.getName();
        if (name != null) {
            this.output.append(name).append(" ");
        }
        this.output.append("{\n");
        for (Map.Entry<String, Object> e : subgraph.getAttributes().entrySet()) {
            this.output.append("    ").append(e.getKey()).append("=").append(this.safeValue(e.getValue())).append(";\n");
        }
        for (GVNode node : subgraph.getNodes()) {
            this.putNode(node);
        }
        for (GVEdge edge : subgraph.getEdges()) {
            this.putEdge(edge);
        }
        this.output.append("  }\n");
    }
}

