/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.graph;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.Builder;
import org.grouplens.lenskit.eval.graph.GVNode;
import org.grouplens.lenskit.eval.graph.HTMLLabel;

class NodeBuilder
implements Builder<GVNode> {
    private final String nodeId;
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private String target;

    private NodeBuilder(String id) {
        this.nodeId = id;
        this.target = id;
    }

    public static NodeBuilder create(String id) {
        return new NodeBuilder(id);
    }

    public NodeBuilder setTarget(String tgt) {
        this.target = tgt;
        return this;
    }

    public NodeBuilder set(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }

    public NodeBuilder add(String name, Object value) {
        Object existing = this.attributes.get(name);
        if (existing == null) {
            return this.set(name, value);
        }
        return this.set(name, existing.toString() + "," + value.toString());
    }

    public NodeBuilder setLabel(String label) {
        return this.set("label", label);
    }

    public NodeBuilder setLabel(HTMLLabel label) {
        return this.set("label", label);
    }

    public NodeBuilder setShape(String shape) {
        return this.set("shape", shape);
    }

    public NodeBuilder setFont(String font) {
        return this.set("fontname", font);
    }

    public GVNode build() {
        return new GVNode(this.nodeId, this.attributes, this.target);
    }
}

