/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.graph;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.Builder;
import org.grouplens.lenskit.eval.graph.GVEdge;
import org.grouplens.lenskit.eval.graph.GVNode;
import org.grouplens.lenskit.eval.graph.GVSubgraph;

class SubgraphBuilder
implements Builder<GVSubgraph> {
    private final List<GVNode> nodes = new ArrayList<GVNode>();
    private final List<GVEdge> edges = new ArrayList<GVEdge>();
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private String name;

    public SubgraphBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public SubgraphBuilder set(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }

    public SubgraphBuilder addNode(GVNode node) {
        this.nodes.add(node);
        return this;
    }

    public SubgraphBuilder addEdge(GVEdge edge) {
        this.edges.add(edge);
        return this;
    }

    public GVSubgraph build() {
        return new GVSubgraph(this.name, this.attributes, this.nodes, this.edges);
    }
}

