/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.metrics.predict;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import org.grouplens.lenskit.eval.algorithm.AlgorithmInstance;
import org.grouplens.lenskit.eval.data.traintest.TTDataSet;
import org.grouplens.lenskit.eval.metrics.AbstractTestUserMetric;
import org.grouplens.lenskit.eval.metrics.TestUserMetricAccumulator;
import org.grouplens.lenskit.eval.traintest.TestUser;
import org.grouplens.lenskit.vectors.SparseVector;
import org.grouplens.lenskit.vectors.VectorEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoveragePredictMetric
extends AbstractTestUserMetric {
    private static final Logger logger = LoggerFactory.getLogger(CoveragePredictMetric.class);
    private static final ImmutableList<String> COLUMNS = ImmutableList.of((Object)"NUsers", (Object)"NAttempted", (Object)"NGood", (Object)"Coverage");
    private static final ImmutableList<String> USER_COLUMNS = ImmutableList.of((Object)"NAttempted", (Object)"NGood", (Object)"Coverage");

    @Override
    public TestUserMetricAccumulator makeAccumulator(AlgorithmInstance algo, TTDataSet ds) {
        return new Accum();
    }

    @Override
    public List<String> getColumnLabels() {
        return COLUMNS;
    }

    @Override
    public List<String> getUserColumnLabels() {
        return USER_COLUMNS;
    }

    class Accum
    implements TestUserMetricAccumulator {
        private int npreds = 0;
        private int ngood = 0;
        private int nusers = 0;

        Accum() {
        }

        @Override
        @Nonnull
        public Object[] evaluate(TestUser user) {
            SparseVector ratings = user.getTestRatings();
            SparseVector predictions = user.getPredictions();
            int n = 0;
            int good = 0;
            for (VectorEntry e : ratings.fast()) {
                double pv = predictions.get(e.getKey());
                ++n;
                if (Double.isNaN(pv)) continue;
                ++good;
            }
            this.npreds += n;
            this.ngood += good;
            ++this.nusers;
            return new Object[]{n, good, n > 0 ? Double.valueOf((double)good / (double)n) : null};
        }

        @Override
        @Nonnull
        public Object[] finalResults() {
            double coverage = (double)this.ngood / (double)this.npreds;
            logger.info("Coverage: {}", (Object)coverage);
            return new Object[]{this.nusers, this.npreds, this.ngood, coverage};
        }
    }
}

