/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.metrics.predict;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;
import org.grouplens.lenskit.data.pref.PreferenceDomain;
import org.grouplens.lenskit.eval.algorithm.AlgorithmInstance;
import org.grouplens.lenskit.eval.data.traintest.TTDataSet;
import org.grouplens.lenskit.eval.metrics.AbstractTestUserMetric;
import org.grouplens.lenskit.eval.metrics.TestUserMetricAccumulator;
import org.grouplens.lenskit.eval.traintest.TestUser;
import org.grouplens.lenskit.transform.quantize.PreferenceDomainQuantizer;
import org.grouplens.lenskit.transform.quantize.Quantizer;
import org.grouplens.lenskit.util.statistics.MutualInformationAccumulator;
import org.grouplens.lenskit.vectors.SparseVector;
import org.grouplens.lenskit.vectors.VectorEntry;
import org.grouplens.lenskit.vectors.Vectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntropyPredictMetric
extends AbstractTestUserMetric {
    private static final Logger logger = LoggerFactory.getLogger(EntropyPredictMetric.class);
    private static final ImmutableList<String> COLUMNS = ImmutableList.of((Object)"Entropy.ofRating.ByUser", (Object)"Entropy.ofPredictions.byUser", (Object)"Information.ByUser");

    @Override
    public TestUserMetricAccumulator makeAccumulator(AlgorithmInstance algorithm, TTDataSet dataSet) {
        return new Accum(dataSet.getPreferenceDomain());
    }

    @Override
    public List<String> getUserColumnLabels() {
        return COLUMNS;
    }

    @Override
    public List<String> getColumnLabels() {
        return COLUMNS;
    }

    class Accum
    implements TestUserMetricAccumulator {
        private Quantizer quantizer;
        private double informationSum = 0.0;
        private double ratingEntropySum = 0.0;
        private double predictionEntropySum = 0.0;
        private int nusers = 0;

        public Accum(PreferenceDomain preferenceDomain) {
            this.quantizer = new PreferenceDomainQuantizer(preferenceDomain);
        }

        @Nonnull
        public String[] evaluate(TestUser user) {
            SparseVector ratings = user.getTestRatings();
            SparseVector predictions = user.getPredictions();
            MutualInformationAccumulator accum = new MutualInformationAccumulator(this.quantizer.getCount());
            for (Pair e : Vectors.fastIntersect((SparseVector)ratings, (SparseVector)predictions)) {
                accum.count(this.quantizer.index(((VectorEntry)e.getLeft()).getValue()), this.quantizer.index(((VectorEntry)e.getRight()).getValue()));
            }
            if (accum.getCount() > 0) {
                double ratingEntropy = accum.getV1Entropy();
                double predEntropy = accum.getV2Entropy();
                double info = accum.getMutualInformation();
                this.informationSum += info;
                this.ratingEntropySum += ratingEntropy;
                this.predictionEntropySum += predEntropy;
                ++this.nusers;
                return new String[]{Double.toString(ratingEntropy), Double.toString(predEntropy), Double.toString(info)};
            }
            return new String[3];
        }

        @Nonnull
        public String[] finalResults() {
            logger.info("H(rating|user): {}", (Object)(this.ratingEntropySum / (double)this.nusers));
            logger.info("H(prediction|user): {}", (Object)(this.predictionEntropySum / (double)this.nusers));
            logger.info("I(rating;prediction): {}", (Object)(this.informationSum / (double)this.nusers));
            return new String[]{Double.toString(this.ratingEntropySum / (double)this.nusers), Double.toString(this.predictionEntropySum / (double)this.nusers), Double.toString(this.informationSum / (double)this.nusers)};
        }
    }
}

