/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.metrics.predict;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.grouplens.lenskit.eval.algorithm.AlgorithmInstance;
import org.grouplens.lenskit.eval.data.traintest.TTDataSet;
import org.grouplens.lenskit.eval.metrics.AbstractTestUserMetric;
import org.grouplens.lenskit.eval.metrics.TestUserMetricAccumulator;
import org.grouplens.lenskit.eval.traintest.TestUser;
import org.grouplens.lenskit.vectors.SparseVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HLUtilityPredictMetric
extends AbstractTestUserMetric {
    private static final Logger logger = LoggerFactory.getLogger(HLUtilityPredictMetric.class);
    private static final List<String> COLUMNS = ImmutableList.of((Object)"HLUtility");
    private double alpha;

    public HLUtilityPredictMetric(double newAlpha) {
        this.alpha = newAlpha;
    }

    public HLUtilityPredictMetric() {
        this.alpha = 5.0;
    }

    @Override
    public Accum makeAccumulator(AlgorithmInstance algo, TTDataSet ds) {
        return new Accum();
    }

    @Override
    public List<String> getColumnLabels() {
        return COLUMNS;
    }

    @Override
    public List<String> getUserColumnLabels() {
        return COLUMNS;
    }

    double computeHLU(LongList items, SparseVector values) {
        double utility = 0.0;
        int rank = 0;
        LongListIterator itemIterator = items.iterator();
        while (itemIterator.hasNext()) {
            double v = values.get(itemIterator.nextLong());
            utility += v / Math.pow(2.0, (double)(++rank - 1) / (this.alpha - 1.0));
        }
        return utility;
    }

    public class Accum
    implements TestUserMetricAccumulator {
        double total = 0.0;
        int nusers = 0;

        @Override
        @Nonnull
        public Object[] evaluate(TestUser user) {
            return this.evaluatePredictions(user.getTestRatings(), user.getPredictions());
        }

        @Nonnull
        Object[] evaluatePredictions(SparseVector ratings, SparseVector predictions) {
            LongArrayList ideal = ratings.keysByValue(true);
            LongArrayList actual = predictions.keysByValue(true);
            double idealUtility = HLUtilityPredictMetric.this.computeHLU((LongList)ideal, ratings);
            double actualUtility = HLUtilityPredictMetric.this.computeHLU((LongList)actual, ratings);
            double u = actualUtility / idealUtility;
            this.total += u;
            ++this.nusers;
            return new Object[]{u};
        }

        @Override
        @Nonnull
        public Object[] finalResults() {
            double v = this.total / (double)this.nusers;
            logger.info("HLU: {}", (Object)v);
            return new Object[]{v};
        }
    }
}

