/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.metrics.predict;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.grouplens.lenskit.eval.algorithm.AlgorithmInstance;
import org.grouplens.lenskit.eval.data.traintest.TTDataSet;
import org.grouplens.lenskit.eval.metrics.AbstractTestUserMetric;
import org.grouplens.lenskit.eval.metrics.TestUserMetricAccumulator;
import org.grouplens.lenskit.eval.traintest.TestUser;
import org.grouplens.lenskit.vectors.SparseVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NDCGPredictMetric
extends AbstractTestUserMetric {
    private static final Logger logger = LoggerFactory.getLogger(NDCGPredictMetric.class);
    private static final ImmutableList<String> COLUMNS = ImmutableList.of((Object)"nDCG");

    @Override
    public Accum makeAccumulator(AlgorithmInstance algo, TTDataSet ds) {
        return new Accum();
    }

    @Override
    public List<String> getColumnLabels() {
        return COLUMNS;
    }

    @Override
    public List<String> getUserColumnLabels() {
        return COLUMNS;
    }

    static double computeDCG(LongList items, SparseVector values) {
        double lg2 = Math.log(2.0);
        double gain = 0.0;
        int rank = 0;
        LongListIterator iit = items.iterator();
        while (iit.hasNext()) {
            long item = iit.nextLong();
            double v = values.get(item);
            if (++rank < 2) {
                gain += v;
                continue;
            }
            gain += v * lg2 / Math.log(rank);
        }
        return gain;
    }

    class Accum
    implements TestUserMetricAccumulator {
        double total = 0.0;
        int nusers = 0;

        Accum() {
        }

        @Override
        @Nonnull
        public Object[] evaluate(TestUser user) {
            return this.evaluatePredictions(user.getTestRatings(), user.getPredictions());
        }

        Object[] evaluatePredictions(SparseVector ratings, SparseVector predictions) {
            LongArrayList ideal = ratings.keysByValue(true);
            LongArrayList actual = predictions.keysByValue(true);
            double idealGain = NDCGPredictMetric.computeDCG((LongList)ideal, ratings);
            double gain = NDCGPredictMetric.computeDCG((LongList)actual, ratings);
            double score = gain / idealGain;
            this.total += score;
            ++this.nusers;
            return new Object[]{score};
        }

        @Override
        @Nonnull
        public Object[] finalResults() {
            double v = this.total / (double)this.nusers;
            logger.info("nDCG: {}", (Object)v);
            return new Object[]{v};
        }
    }
}

