/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.script;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.JdkFutureAdapters;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import groovy.lang.Closure;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.grouplens.lenskit.config.GroovyUtils;
import org.grouplens.lenskit.eval.EvalConfig;
import org.grouplens.lenskit.eval.EvalProject;
import org.grouplens.lenskit.eval.script.BuiltBy;
import org.grouplens.lenskit.eval.script.ConfigDelegate;
import org.grouplens.lenskit.eval.script.DefaultConfigDelegate;
import org.grouplens.lenskit.eval.script.EvalScriptEngine;
import org.grouplens.lenskit.util.Functional;

public class ConfigMethodInvoker {
    private final EvalScriptEngine engine;
    private final EvalProject project;
    private final Map<Object, List<ListenableFuture<?>>> objectDependencies = Maps.newIdentityHashMap();

    public ConfigMethodInvoker(@Nonnull EvalScriptEngine engine, @Nonnull EvalProject project) {
        this.engine = engine;
        this.project = project;
    }

    public synchronized void registerDep(Object obj, ListenableFuture<?> dep) {
        Preconditions.checkArgument((obj != dep ? 1 : 0) != 0, (Object)"Object cannot depend on itself");
        LinkedList deps = this.objectDependencies.get(obj);
        if (deps == null) {
            deps = Lists.newLinkedList();
            this.objectDependencies.put(obj, deps);
        }
        deps.add(dep);
    }

    public synchronized List<ListenableFuture<?>> getDeps(Object obj) {
        List<ListenableFuture<?>> deps = this.objectDependencies.get(obj);
        if (deps == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(deps);
    }

    public synchronized void clearDeps(Object obj) {
        this.objectDependencies.remove(obj);
    }

    Iterable<Method> getOneArgMethods(Object obj, final String name) {
        return Iterables.filter(Arrays.asList(obj.getClass().getMethods()), (Predicate)new Predicate<Method>(){

            public boolean apply(@Nullable Method method) {
                if (method == null) {
                    return false;
                }
                return method.getName().equals(name) && method.getParameterTypes().length == 1;
            }
        });
    }

    Object finishBuilder(final Builder<?> builder) {
        List<ListenableFuture<?>> deps = this.getDeps(builder);
        this.clearDeps(builder);
        if (deps.isEmpty()) {
            return builder.build();
        }
        ListenableFuture ideps = Futures.allAsList(deps);
        if (ideps.isDone()) {
            return builder.build();
        }
        return Futures.transform((ListenableFuture)ideps, (Function)new Function<List<Object>, Object>(){

            @Nullable
            public Object apply(@Nullable List<Object> input) {
                return builder.build();
            }
        });
    }

    Object transform(Object obj, Function<Object, ?> function) {
        if (obj instanceof Future) {
            return Futures.transform((ListenableFuture)JdkFutureAdapters.listenInPoolThread((Future)((Future)obj)), function);
        }
        return function.apply(obj);
    }

    private Supplier<Object> findBuildableMethod(final Object self, String name, final Object[] args) {
        Supplier<Object> result = null;
        for (final Method method : this.getOneArgMethods(self, name)) {
            Class<Object> bldClass;
            Class<?> param = method.getParameterTypes()[0];
            BuiltBy annot = method.getAnnotation(BuiltBy.class);
            if (annot == null) {
                annot = param.getAnnotation(BuiltBy.class);
            }
            if ((bldClass = annot != null ? annot.value() : this.engine.getBuilderForType(param)) == null) continue;
            if (result != null) {
                throw new RuntimeException("multiple buildable methods named " + name);
            }
            result = new Supplier<Object>(){

                public Object get() {
                    try {
                        Builder builder = (Builder)ConfigMethodInvoker.this.constructAndConfigure(bldClass, args);
                        Object val = ConfigMethodInvoker.this.transform(ConfigMethodInvoker.this.finishBuilder(builder), Functional.invokeMethod((Method)method, (Object)self));
                        if (val != self && val instanceof ListenableFuture) {
                            ConfigMethodInvoker.this.registerDep(self, (ListenableFuture)val);
                        }
                        return val;
                    }
                    catch (NoSuchMethodException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            };
        }
        return result;
    }

    private Supplier<Object> findMultiMethod(final Object self, String name, Object[] args) {
        if (args.length != 1) {
            return null;
        }
        Object arg = args[0];
        if (!(arg instanceof Iterable)) {
            return null;
        }
        final Iterable objects = (Iterable)arg;
        Supplier<Object> result = null;
        for (final Method method : this.getOneArgMethods(self, name)) {
            Class<?> ptype = method.getParameterTypes()[0];
            boolean good = Iterables.all((Iterable)objects, (Predicate)Predicates.or((Predicate)Predicates.isNull(), (Predicate)Predicates.instanceOf(ptype)));
            if (!good) continue;
            if (result != null) {
                throw new RuntimeException("multiple compatible methods named " + name);
            }
            result = new Supplier<Object>(){

                public Object get() {
                    for (Object obj : objects) {
                        try {
                            method.invoke(self, obj);
                        }
                        catch (IllegalAccessException e) {
                            throw Throwables.propagate((Throwable)e);
                        }
                        catch (InvocationTargetException e) {
                            if (e.getCause() == null) continue;
                            throw Throwables.propagate((Throwable)e);
                        }
                    }
                    return null;
                }
            };
        }
        return result;
    }

    private Supplier<Object> findMethod(final Object self, String name, Object[] args) {
        Class cls;
        MetaMethod method;
        Class[] at2;
        Object lastArg;
        Object[] objects = Arrays.copyOf(args, args.length);
        Class[] types = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (objects[i] == null) continue;
            types[i] = objects[i].getClass();
        }
        MetaClass metaclass = InvokerHelper.getMetaClass((Object)self);
        MetaMethod mm = metaclass.pickMethod(name, types);
        if (mm == null && objects.length > 0 && (lastArg = objects[objects.length - 1]) instanceof Closure) {
            at2 = Arrays.copyOf(types, types.length);
            at2[objects.length - 1] = Function.class;
            mm = metaclass.pickMethod(name, at2);
            if (mm != null) {
                objects[objects.length - 1] = new ClosureFunction((Closure)lastArg);
            }
        }
        if (mm == null && objects.length == 1 && objects[0] instanceof Class && (method = metaclass.pickMethod(name, at2 = new Class[]{cls = (Class)objects[0]})) != null) {
            try {
                final Constructor ctor = cls.getConstructor(new Class[0]);
                return new Supplier<Object>(){

                    public Object get() {
                        Object[] objs;
                        try {
                            objs = new Object[]{ctor.newInstance(new Object[0])};
                        }
                        catch (InstantiationException e) {
                            throw new RuntimeException("cannot instantiate " + cls, e);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException("cannot instantiate " + cls, e);
                        }
                        catch (InvocationTargetException e) {
                            throw new RuntimeException("cannot instantiate " + cls, e);
                        }
                        return method.doMethodInvoke(self, objs);
                    }
                };
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (mm == null) {
            return null;
        }
        final MetaMethod method2 = mm;
        final Object[] finalArgs = objects;
        return new Supplier<Object>(){

            public Object get() {
                return method2.doMethodInvoke(self, finalArgs);
            }
        };
    }

    private Object makeConfigDelegate(Object target) {
        ConfigDelegate annot = target.getClass().getAnnotation(ConfigDelegate.class);
        if (annot == null) {
            return new DefaultConfigDelegate(this, target);
        }
        Class<?> dlgClass = annot.value();
        try {
            return ConstructorUtils.invokeConstructor(dlgClass, (Object[])new Object[]{target});
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("error constructing " + dlgClass, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("error constructing " + dlgClass, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("error constructing " + dlgClass, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("error constructing " + dlgClass, e);
        }
    }

    public Pair<Object[], Closure> splitClosure(Object[] args) {
        if (args.length > 0 && args[args.length - 1] instanceof Closure) {
            return Pair.of((Object)Arrays.copyOf(args, args.length - 1), (Object)((Closure)args[args.length - 1]));
        }
        return Pair.of((Object)args, null);
    }

    private <T> T constructAndConfigure(Class<T> type, Object[] args) throws NoSuchMethodException {
        Object obj;
        Pair<Object[], Closure> split = this.splitClosure(args);
        MetaClass metaclass = InvokerHelper.getMetaClass(type);
        try {
            obj = metaclass.invokeConstructor((Object[])split.getLeft());
        }
        catch (GroovyRuntimeException e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), NoSuchMethodException.class);
            throw e;
        }
        metaclass = InvokerHelper.getMetaClass((Object)obj);
        MetaMethod mm = metaclass.getMetaMethod("setEvalConfig", (Object[])new Class[]{EvalConfig.class});
        if (mm != null) {
            mm.invoke(obj, new Object[]{this.project.getConfig()});
        }
        if ((mm = metaclass.getMetaMethod("setEvalProject", (Object[])new Class[]{EvalProject.class})) == null) {
            mm = metaclass.getMetaMethod("setProject", (Object[])new Class[]{EvalProject.class});
        }
        if (mm != null) {
            mm.invoke(obj, new Object[]{this.project});
        }
        if (split.getRight() != null) {
            GroovyUtils.callWithDelegate((Closure)((Closure)split.getRight()), (Object)this.makeConfigDelegate(obj));
        }
        return type.cast(obj);
    }

    public Object callExternalMethod(String name, Object ... args) throws NoSuchMethodException {
        Class<?> mtype = this.engine.lookupMethod(name);
        if (mtype != null) {
            try {
                return this.constructAndConfigure(mtype, args);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("cannot find suitable for " + mtype.toString(), e);
            }
        }
        throw new NoSuchMethodException(name);
    }

    public Object invokeConfigurationMethod(final Object target, final String name, Object ... args) {
        Preconditions.checkNotNull((Object)target, (Object)"target object");
        if (args.length == 1 && args[0] instanceof Future) {
            Future f = (Future)args[0];
            if (f.isDone()) {
                try {
                    Object arg = Uninterruptibles.getUninterruptibly((Future)f);
                    return this.invokeConfigurationMethod(target, name, arg);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e.getCause());
                }
            }
            Function<Object, Object> recur = new Function<Object, Object>(){

                @Nullable
                public Object apply(@Nullable Object input) {
                    return ConfigMethodInvoker.this.invokeConfigurationMethod(target, name, input);
                }
            };
            ListenableFuture f2 = Futures.transform((ListenableFuture)JdkFutureAdapters.listenInPoolThread((Future)f), (Function)recur);
            this.registerDep(target, f2);
            return f2;
        }
        String setterName = "set" + StringUtils.capitalize((String)name);
        String adderName = "add" + StringUtils.capitalize((String)name);
        Supplier<Object> inv = this.findMethod(target, name, args);
        if (inv == null) {
            inv = this.findBuildableMethod(target, name, args);
        }
        if (inv == null) {
            inv = this.findMethod(target, setterName, args);
        }
        if (inv == null) {
            inv = this.findBuildableMethod(target, setterName, args);
        }
        if (inv == null) {
            inv = this.findMethod(target, adderName, args);
        }
        if (inv == null) {
            inv = this.findMultiMethod(target, adderName, args);
        }
        if (inv == null) {
            inv = this.findBuildableMethod(target, adderName, args);
        }
        if (inv != null) {
            return inv.get();
        }
        return DefaultGroovyMethods.invokeMethod((Object)target, (String)name, (Object)args);
    }

    private static class ClosureFunction
    implements Function {
        private Closure closure;

        public ClosureFunction(Closure cl) {
            this.closure = cl;
        }

        public Object apply(Object input) {
            return this.closure.call(input);
        }
    }
}

