/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.script;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Uninterruptibles;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GroovyObject;
import groovy.lang.MissingMethodException;
import groovy.lang.Script;
import groovy.util.AntBuilder;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.apache.commons.lang3.builder.Builder;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.grouplens.lenskit.config.GroovyUtils;
import org.grouplens.lenskit.eval.EvalAntTask;
import org.grouplens.lenskit.eval.EvalConfig;
import org.grouplens.lenskit.eval.EvalProject;
import org.grouplens.lenskit.eval.EvalTarget;
import org.grouplens.lenskit.eval.EvalTask;
import org.grouplens.lenskit.eval.TaskExecutionException;
import org.grouplens.lenskit.eval.script.ConfigMethodInvoker;
import org.grouplens.lenskit.eval.script.EvalScriptEngine;
import org.grouplens.lenskit.eval.script.LenskitAntBuilder;
import org.grouplens.lenskit.eval.script.TargetDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalScript
extends Script
implements GroovyObject {
    public final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private EvalScriptEngine engine;
    private ConfigMethodInvoker helper;
    private EvalProject project;
    private Target currentTarget;
    private AntBuilder ant;

    public EvalConfig getConfig() {
        return this.project.getConfig();
    }

    public EvalScriptEngine getEngine() {
        Preconditions.checkState((this.engine != null ? 1 : 0) != 0, (Object)"no script engine configured");
        return this.engine;
    }

    public void setEngine(EvalScriptEngine ece) {
        this.engine = ece;
        if (this.project != null) {
            this.helper = new ConfigMethodInvoker(ece, this.project);
        }
    }

    public EvalProject getProject() {
        Preconditions.checkState((this.project != null ? 1 : 0) != 0, (Object)"no project configured");
        return this.project;
    }

    public void setProject(EvalProject prj) {
        this.project = prj;
        this.ant = new LenskitAntBuilder(this.getAntProject());
        if (this.engine != null) {
            this.helper = new ConfigMethodInvoker(this.engine, this.project);
        }
    }

    public EvalScript getEval() {
        return this;
    }

    public Project getAntProject() {
        return this.getProject().getAntProject();
    }

    public AntBuilder getAnt() {
        Preconditions.checkState((this.ant != null ? 1 : 0) != 0, (Object)"no project configured");
        return this.ant;
    }

    public Task ant(Closure<?> block) {
        return (Task)this.getAnt().invokeMethod("sequential", block);
    }

    public Object evalScript(File file) throws IOException, TaskExecutionException {
        return this.engine.runScript(file, this.project);
    }

    public Object evalScript(String fn) throws IOException, TaskExecutionException {
        return this.evalScript(new File(fn));
    }

    public List<String> glob(String globPattern) {
        return this.glob(globPattern, ".");
    }

    public List<String> glob(String globPattern, String baseDir) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setIncludes(new String[]{globPattern});
        ds.setBasedir(baseDir);
        ds.scan();
        return ImmutableList.copyOf((Object[])ds.getIncludedFiles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvalTarget target(String name, @DelegatesTo(value=TargetDelegate.class, strategy=1) Closure<?> closure) {
        if (this.currentTarget != null) {
            throw new IllegalStateException("cannot nest targets");
        }
        EvalTarget target = new EvalTarget();
        target.setName(name);
        target.setProject(this.getAntProject());
        TargetDelegate delegate = new TargetDelegate(target);
        this.currentTarget = target;
        try {
            GroovyUtils.callWithDelegate(closure, (Object)delegate);
        }
        finally {
            this.currentTarget = null;
        }
        this.getAntProject().addTarget((Target)target);
        return target;
    }

    public void defaultTarget(String name) {
        this.project.setDefaultTarget(name);
    }

    public void defaultTarget(Target target) {
        if (target == null) {
            this.project.setDefaultTarget(null);
        } else {
            this.project.setDefaultTarget(target.getName());
        }
    }

    public Object methodMissing(String name, Object arg) {
        Object[] args = InvokerHelper.asArray((Object)arg);
        this.logger.debug("searching for eval command {}", (Object)name);
        Object obj = null;
        try {
            obj = this.helper.callExternalMethod(name, args);
        }
        catch (NoSuchMethodException e) {
            throw new MissingMethodException(name, ((Object)((Object)this)).getClass(), args, true);
        }
        if (obj instanceof Builder) {
            return this.helper.finishBuilder((Builder)obj);
        }
        if (obj instanceof EvalTask) {
            final EvalTask task = (EvalTask)obj;
            if (this.currentTarget == null) {
                try {
                    ListenableFuture deps = Futures.allAsList(this.helper.getDeps(task));
                    this.helper.clearDeps(task);
                    Runnable execute = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                task.execute();
                            }
                            catch (TaskExecutionException e) {
                                throw new RuntimeException("task failure", e);
                            }
                        }
                    };
                    deps.addListener(execute, (Executor)MoreExecutors.sameThreadExecutor());
                    if (task.isDone()) {
                        return Uninterruptibles.getUninterruptibly((Future)((Object)task));
                    }
                    return task;
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("task failure", e);
                }
            }
            EvalAntTask aTask = new EvalAntTask(task, this.helper.getDeps(task));
            aTask.setProject(this.getAntProject());
            aTask.setOwningTarget(this.currentTarget);
            aTask.init();
            this.currentTarget.addTask((Task)aTask);
            return obj;
        }
        return obj;
    }

    public Object run() {
        throw new UnsupportedOperationException("script not implemented");
    }
}

