/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.script;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.Builder;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.grouplens.lenskit.eval.EvalProject;
import org.grouplens.lenskit.eval.EvalTask;
import org.grouplens.lenskit.eval.TaskExecutionException;
import org.grouplens.lenskit.eval.script.BuiltBy;
import org.grouplens.lenskit.eval.script.EvalScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalScriptEngine {
    private static Logger logger = LoggerFactory.getLogger(EvalScriptEngine.class);
    private static final String METHOD_PATH = "META-INF/lenskit-eval/methods/";
    protected ClassLoader classLoader;
    protected GroovyShell shell;
    @Nullable
    protected final Properties properties;
    private final Map<Class, Class> builders = new HashMap<Class, Class>();

    public EvalScriptEngine() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public EvalScriptEngine(ClassLoader loader) {
        this(loader, null);
    }

    public EvalScriptEngine(ClassLoader loader, @Nullable Properties props) {
        CompilerConfiguration compConfig = new CompilerConfiguration(CompilerConfiguration.DEFAULT);
        this.properties = props;
        compConfig.setScriptBaseClass("org.grouplens.lenskit.eval.script.EvalScript");
        ImportCustomizer imports = new ImportCustomizer();
        imports.addStarImports(new String[]{"org.grouplens.lenskit", "org.grouplens.lenskit.params", "org.grouplens.lenskit.baseline", "org.grouplens.lenskit.norm", "org.grouplens.lenskit.eval.metrics.predict", "org.grouplens.lenskit.eval.metrics.recommend"});
        compConfig.addCompilationCustomizers(new CompilationCustomizer[]{imports});
        this.shell = new GroovyShell(loader, new Binding(), compConfig);
        this.classLoader = loader;
        this.loadExternalMethods();
    }

    public EvalProject createProject() {
        return new EvalProject(this.properties);
    }

    public Object runScript(File file, EvalProject project) throws IOException, TaskExecutionException {
        EvalScript script = (EvalScript)this.shell.parse(file);
        return this.runScript(script, project);
    }

    public Object runScript(Reader in, EvalProject project) throws IOException {
        EvalScript script;
        try {
            script = (EvalScript)this.shell.parse(in);
        }
        catch (GroovyRuntimeException e) {
            Throwables.propagateIfInstanceOf((Throwable)e, IOException.class);
            throw e;
        }
        return script;
    }

    @Nullable
    public Object runScript(EvalScript script, EvalProject project) throws TaskExecutionException {
        script.setEngine(this);
        script.setProject(project);
        Object result = null;
        try {
            result = script.run();
        }
        catch (RuntimeException e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), TaskExecutionException.class);
            throw new TaskExecutionException("error running configuration script", e);
        }
        return result;
    }

    public EvalProject loadProject(File file) throws TaskExecutionException, IOException {
        logger.debug("loading script file {}", (Object)file);
        EvalProject project = new EvalProject(this.properties);
        this.runScript(file, project);
        return project;
    }

    public Object loadProject(Reader in) throws TaskExecutionException, IOException {
        EvalProject project = this.createProject();
        this.runScript(in, project);
        return project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R> Class<? extends R> lookupMethod(Class<R> root, String key, String name) {
        String path = METHOD_PATH + name + ".properties";
        logger.debug("loading method {} from {}", (Object)name, (Object)path);
        try {
            InputStream istr = this.classLoader.getResourceAsStream(path);
            if (istr == null) {
                logger.debug("path {} not found", (Object)path);
                return null;
            }
            try {
                String className;
                Properties props = new Properties();
                props.load(istr);
                Object pv = props.get(key);
                String string = className = pv == null ? null : pv.toString();
                if (className == null) {
                    Class<? extends R> clazz = null;
                    return clazz;
                }
                Class<R> clazz = this.classLoader.loadClass(className).asSubclass(root);
                return clazz;
            }
            finally {
                istr.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("error reading method " + name, e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("cannot find command class", e);
        }
    }

    public Class<?> lookupMethod(@Nonnull String name) {
        Class<? extends EvalTask> task = this.lookupTask(name);
        Class<? extends Builder> builder = this.lookupBuilder(name);
        if (task == null && builder == null) {
            return null;
        }
        if (task != null) {
            if (builder == null) {
                return task;
            }
            throw new RuntimeException("ambiguous method " + name);
        }
        return builder;
    }

    @CheckForNull
    @Nullable
    public Class<? extends EvalTask> lookupTask(@Nonnull String name) {
        return this.lookupMethod(EvalTask.class, "task", name);
    }

    @CheckForNull
    @Nullable
    public Class<? extends Builder> lookupBuilder(@Nonnull String name) {
        return this.lookupMethod(Builder.class, "builder", name);
    }

    public <T> Class<? extends Builder> getBuilderForType(Class<T> type) {
        BuiltBy annot;
        Class<? extends Builder> builder = this.builders.get(type);
        if (builder == null && (annot = type.getAnnotation(BuiltBy.class)) != null) {
            builder = annot.value();
        }
        return builder;
    }

    public <T> void registerCommand(Class<T> type, Class<? extends Builder> command) {
        Preconditions.checkNotNull(type, (Object)"type cannot be null");
        Preconditions.checkNotNull(command, (Object)"command cannot be null");
        this.builders.put(type, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadExternalMethods() {
        Properties props = new Properties();
        try {
            for (URL uRL : Collections.list(this.classLoader.getResources("META-INF/lenskit-eval/builders.properties"))) {
                InputStream istr = uRL.openStream();
                try {
                    props.load(istr);
                }
                finally {
                    istr.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry entry : props.entrySet()) {
            Class<Builder> cmd;
            Class<?> cls;
            String name = entry.getKey().toString();
            String command = entry.getValue().toString();
            try {
                cls = this.classLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                logger.warn("command registered for nonexistent class {}", (Object)name);
                continue;
            }
            try {
                cmd = Class.forName(command).asSubclass(Builder.class);
            }
            catch (ClassNotFoundException e) {
                logger.error("command class {} not builder", (Object)command);
                continue;
            }
            catch (ClassCastException e) {
                logger.error("class {} is not a builder", (Object)command);
                continue;
            }
            logger.debug("registering {} as builder for {}", (Object)command, cls);
            this.registerCommand(cls, cmd);
        }
    }
}

