/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.traintest;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.grouplens.lenskit.Recommender;
import org.grouplens.lenskit.eval.algorithm.AlgorithmInstance;
import org.grouplens.lenskit.eval.data.traintest.TTDataSet;
import org.grouplens.lenskit.eval.traintest.ModelMetric;
import org.grouplens.lenskit.eval.traintest.TrainTestEvalTask;

public class FunctionModelMetric
implements ModelMetric {
    private final List<String> columnHeaders;
    private final Function<Recommender, List<Object>> function;

    public FunctionModelMetric(List<String> columns, Function<Recommender, List<Object>> func) {
        this.columnHeaders = ImmutableList.copyOf(columns);
        this.function = func;
    }

    @Override
    public List<String> getColumnLabels() {
        return this.columnHeaders;
    }

    @Override
    public List<Object> measureAlgorithm(AlgorithmInstance instance, TTDataSet data, Recommender recommender) {
        return (List)this.function.apply((Object)recommender);
    }

    @Override
    public void startEvaluation(TrainTestEvalTask eval) {
    }

    @Override
    public void finishEvaluation() {
    }
}

