/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.traintest;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.grouplens.lenskit.Recommender;
import org.grouplens.lenskit.eval.algorithm.AlgorithmInstance;
import org.grouplens.lenskit.eval.data.traintest.TTDataSet;
import org.grouplens.lenskit.eval.traintest.ModelMetric;
import org.grouplens.lenskit.eval.traintest.TrainTestEvalTask;
import org.grouplens.lenskit.util.table.TableLayoutBuilder;
import org.grouplens.lenskit.util.table.writer.CSVWriter;
import org.grouplens.lenskit.util.table.writer.TableWriter;

public class FunctionMultiModelMetric
implements ModelMetric {
    private final File outputFile;
    private final List<String> columnHeaders;
    private final Function<Recommender, List<List<Object>>> function;
    private TableWriter writer;
    private TrainTestEvalTask currentEval;

    public FunctionMultiModelMetric(File file, List<String> columns, Function<Recommender, List<List<Object>>> func) {
        this.outputFile = file;
        this.columnHeaders = Lists.newArrayList(columns);
        this.function = func;
    }

    @Override
    public List<String> getColumnLabels() {
        return Collections.emptyList();
    }

    @Override
    public List<Object> measureAlgorithm(AlgorithmInstance instance, TTDataSet data, Recommender recommender) {
        Preconditions.checkState((this.currentEval != null ? 1 : 0) != 0, (Object)"evaluation not in progress");
        TableWriter w = this.currentEval.prefixTable(this.writer, instance, data);
        for (List row : (List)this.function.apply((Object)recommender)) {
            try {
                w.writeRow(row.toArray());
            }
            catch (IOException e) {
                throw new RuntimeException("error writing row", e);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void startEvaluation(TrainTestEvalTask eval) {
        TableLayoutBuilder builder = TableLayoutBuilder.copy(eval.getMasterLayout());
        for (String col : this.columnHeaders) {
            builder.addColumn(col);
        }
        try {
            this.writer = CSVWriter.open(this.outputFile, builder.build());
        }
        catch (IOException e) {
            throw new RuntimeException("error opening output file", e);
        }
        this.currentEval = eval;
    }

    @Override
    public void finishEvaluation() {
        this.currentEval = null;
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException("error closing output file", e);
        }
    }
}

