/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.traintest;

import it.unimi.dsi.fastutil.longs.LongCollection;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.inject.Provider;
import org.apache.commons.lang3.time.StopWatch;
import org.grouplens.lenskit.collections.FastCollection;
import org.grouplens.lenskit.core.Shareable;
import org.grouplens.lenskit.data.dao.EventDAO;
import org.grouplens.lenskit.data.pref.IndexedPreference;
import org.grouplens.lenskit.data.snapshot.PackedPreferenceSnapshot;
import org.grouplens.lenskit.data.snapshot.PreferenceSnapshot;
import org.grouplens.lenskit.eval.data.traintest.TTDataSet;
import org.grouplens.lenskit.util.Index;
import org.grouplens.lenskit.util.SoftMemoizingProvider;
import org.grouplens.lenskit.vectors.SparseVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Shareable
public class SharedPreferenceSnapshot
implements PreferenceSnapshot,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SharedPreferenceSnapshot.class);
    private final PreferenceSnapshot snapshot;

    public SharedPreferenceSnapshot(PreferenceSnapshot snapshot) {
        this.snapshot = snapshot;
    }

    public LongCollection getUserIds() {
        return this.snapshot.getUserIds();
    }

    public LongCollection getItemIds() {
        return this.snapshot.getItemIds();
    }

    public Index userIndex() {
        return this.snapshot.userIndex();
    }

    public Index itemIndex() {
        return this.snapshot.itemIndex();
    }

    public FastCollection<IndexedPreference> getRatings() {
        return this.snapshot.getRatings();
    }

    public FastCollection<IndexedPreference> getUserRatings(long userId) {
        return this.snapshot.getUserRatings(userId);
    }

    public void close() {
    }

    public SparseVector userRatingVector(long userId) {
        return this.snapshot.userRatingVector(userId);
    }

    public static Provider<PreferenceSnapshot> provider(TTDataSet data) {
        return new SnapProvider(data);
    }

    private static class SnapProvider
    extends SoftMemoizingProvider<PreferenceSnapshot> {
        private final TTDataSet dataSet;

        public SnapProvider(@Nonnull TTDataSet data) {
            this.dataSet = data;
        }

        public SharedPreferenceSnapshot newValue() {
            logger.info("Loading snapshot for {}", (Object)this.dataSet.getName());
            StopWatch timer = new StopWatch();
            timer.start();
            EventDAO dao = this.dataSet.getTrainingDAO();
            PreferenceSnapshot snapshot = PackedPreferenceSnapshot.pack((EventDAO)dao);
            timer.stop();
            logger.info("Rating snapshot for {} loaded in {}", (Object)this.dataSet.getName(), (Object)timer);
            return new SharedPreferenceSnapshot(snapshot);
        }
    }
}

