/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.traintest;

import java.io.File;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.inject.Provider;
import org.grouplens.grapht.util.Providers;
import org.grouplens.lenskit.data.dao.EventDAO;
import org.grouplens.lenskit.data.pref.PreferenceDomain;
import org.grouplens.lenskit.eval.EvalConfig;
import org.grouplens.lenskit.eval.EvalProject;
import org.grouplens.lenskit.eval.TaskExecutionException;
import org.grouplens.lenskit.eval.algorithm.LenskitAlgorithmInstance;
import org.grouplens.lenskit.eval.algorithm.LenskitAlgorithmInstanceBuilder;
import org.grouplens.lenskit.eval.data.DataSource;
import org.grouplens.lenskit.eval.data.crossfold.CrossfoldTask;
import org.grouplens.lenskit.eval.data.traintest.GenericTTDataSet;
import org.grouplens.lenskit.eval.data.traintest.TTDataSet;
import org.grouplens.lenskit.eval.metrics.TestUserMetric;
import org.grouplens.lenskit.eval.traintest.TrainTestEvalTask;
import org.grouplens.lenskit.util.table.Table;

public class SimpleEvaluator
implements Callable<Table> {
    private final EvalProject project;
    private TrainTestEvalTask result;

    public SimpleEvaluator() {
        this(null);
    }

    public SimpleEvaluator(Properties props) {
        this.project = new EvalProject(props);
        this.result = new TrainTestEvalTask("simple-eval");
        this.result.setProject(this.project);
        this.result.setOutput((File)null);
    }

    public EvalConfig getEvalConfig() {
        return this.project.getConfig();
    }

    public SimpleEvaluator addAlgorithm(LenskitAlgorithmInstance algo) {
        this.result.addAlgorithm(algo);
        return this;
    }

    public SimpleEvaluator addAlgorithm(LenskitAlgorithmInstanceBuilder algo) {
        this.result.addAlgorithm(algo.build());
        return this;
    }

    public SimpleEvaluator addDataset(CrossfoldTask cross) {
        try {
            Iterator i$ = cross.perform().iterator();
            while (i$.hasNext()) {
                TTDataSet data = (TTDataSet)i$.next();
                this.result.addDataset(data);
            }
        }
        catch (TaskExecutionException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public SimpleEvaluator addDataset(String name, DataSource source, int partitions, double holdout) {
        CrossfoldTask cross = new CrossfoldTask(name).setSource(source).setPartitions(partitions).setHoldoutFraction(holdout);
        cross.setProject(this.project);
        this.addDataset(cross);
        return this;
    }

    public SimpleEvaluator addDataset(DataSource source, int partitions, double holdout) {
        return this.addDataset(source.getName(), source, partitions, holdout);
    }

    public SimpleEvaluator addDataset(String name, DataSource source, int partitions) {
        return this.addDataset(name, source, partitions, 0.2);
    }

    public SimpleEvaluator addDataset(DataSource source, int partitions) {
        return this.addDataset(source.getName(), source, partitions, 0.2);
    }

    public SimpleEvaluator addDataset(TTDataSet data) {
        this.result.addDataset(data);
        return this;
    }

    public SimpleEvaluator addDataset(String name, EventDAO train, EventDAO test, PreferenceDomain dom) {
        this.result.addDataset(new GenericTTDataSet(name, (Provider<EventDAO>)Providers.of((Object)train), (Provider<EventDAO>)Providers.of((Object)test), dom));
        return this;
    }

    public SimpleEvaluator addDataset(DataSource train, DataSource test, PreferenceDomain dom) {
        this.result.addDataset(new GenericTTDataSet("generic-data-source", train, test, dom, null));
        return this;
    }

    public SimpleEvaluator addMetric(TestUserMetric metric) {
        this.result.addMetric(metric);
        return this;
    }

    public SimpleEvaluator setOutput(File file) {
        this.result.setOutput(file);
        return this;
    }

    public SimpleEvaluator setPredictOutput(File file) {
        this.result.setPredictOutput(file);
        return this;
    }

    public SimpleEvaluator setUserOutput(File file) {
        this.result.setUserOutput(file);
        return this;
    }

    public SimpleEvaluator setOutputPath(String path) {
        this.result.setOutput(new File(path));
        return this;
    }

    public SimpleEvaluator setPredictOutputPath(String path) {
        this.result.setPredictOutput(new File(path));
        return this;
    }

    public SimpleEvaluator setUserOutputPath(String path) {
        this.result.setUserOutput(new File(path));
        return this;
    }

    public TrainTestEvalTask getRawCommand() {
        return this.result;
    }

    @Override
    public Table call() throws TaskExecutionException {
        this.result.setProject(this.project);
        return this.result.perform();
    }
}

