/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval.traintest;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.List;
import org.grouplens.lenskit.data.event.Event;
import org.grouplens.lenskit.data.history.RatingVectorUserHistorySummarizer;
import org.grouplens.lenskit.data.history.UserHistory;
import org.grouplens.lenskit.scored.ScoredId;
import org.grouplens.lenskit.vectors.SparseVector;

public class TestUser {
    private final long userId;
    private Supplier<UserHistory<Event>> historySupplier;
    private Supplier<UserHistory<Event>> testHistorySupplier;
    private Supplier<SparseVector> predSupplier;
    private Supplier<List<ScoredId>> recSupplier;

    public TestUser(long id, Supplier<UserHistory<Event>> hist, Supplier<UserHistory<Event>> testHist, Supplier<SparseVector> predictions, Supplier<List<ScoredId>> recommendations) {
        this.userId = id;
        this.historySupplier = Suppliers.memoize(hist);
        this.testHistorySupplier = Suppliers.memoize(testHist);
        this.predSupplier = Suppliers.memoize(predictions);
        this.recSupplier = Suppliers.memoize(recommendations);
    }

    public long getUserId() {
        return this.userId;
    }

    @Deprecated
    public UserHistory<Event> getHistory() {
        return (UserHistory)this.historySupplier.get();
    }

    public UserHistory<Event> getTrainHistory() {
        return (UserHistory)this.historySupplier.get();
    }

    public UserHistory<Event> getTestHistory() {
        return (UserHistory)this.testHistorySupplier.get();
    }

    public SparseVector getTestRatings() {
        return RatingVectorUserHistorySummarizer.makeRatingVector(this.getTestHistory());
    }

    public SparseVector getPredictions() {
        return (SparseVector)this.predSupplier.get();
    }

    public List<ScoredId> getRecommendations() {
        return (List)this.recSupplier.get();
    }
}

