/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.util.table;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.util.AbstractList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.grouplens.lenskit.util.table.Column;
import org.grouplens.lenskit.util.table.Row;
import org.grouplens.lenskit.util.table.Table;

class ColumnImpl
extends AbstractList<Object>
implements Column {
    private final Table table;
    private final int column;
    private final String columnName;

    public ColumnImpl(Table tbl, int col, String name) {
        this.table = tbl;
        this.column = col;
        this.columnName = name;
    }

    @Override
    public Object get(int index) {
        return ((Row)this.table.get(index)).value(this.column);
    }

    @Override
    public int size() {
        return this.table.size();
    }

    @Override
    @Nonnull
    public Iterator<Object> iterator() {
        return Iterators.transform(this.table.iterator(), (Function)new Function<Row, Object>(){

            @Nullable
            public Object apply(@Nullable Row row) {
                assert (row != null);
                return row.value(ColumnImpl.this.column);
            }
        });
    }

    @Override
    public double sum() {
        double sum = 0.0;
        for (Object v : this) {
            if (v instanceof Number) {
                sum += ((Number)v).doubleValue();
                continue;
            }
            if (v == null) {
                return Double.NaN;
            }
            throw new IllegalArgumentException(String.format("non-numeric entry in column %d (%s)", this.column, this.columnName));
        }
        return sum;
    }

    @Override
    public double average() {
        int sz = this.size();
        if (sz == 0) {
            return Double.NaN;
        }
        return this.sum() / (double)this.size();
    }
}

