/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.util.table;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.grouplens.lenskit.util.table.Row;
import org.grouplens.lenskit.util.table.TableLayout;

class RowImpl
implements Row {
    private final ArrayList<Object> row;
    private final TableLayout layout;
    private final Function<String, Object> VALUE_FUNCTION = new Function<String, Object>(){

        public Object apply(@Nullable String column) {
            return RowImpl.this.value(column);
        }
    };

    public RowImpl(TableLayout layout, Object[] entries) {
        this.layout = layout;
        Preconditions.checkArgument((entries.length == layout.getColumnCount() ? 1 : 0) != 0, (Object)String.format("row has incorrect length (was %d, expected %d)", entries.length, layout.getColumnCount()));
        this.row = new ArrayList(entries.length);
        Collections.addAll(this.row, entries);
    }

    @Override
    public Object value(String col) {
        return this.value(this.layout.columnIndex(col));
    }

    @Override
    public Object value(int idx) {
        Preconditions.checkElementIndex((int)idx, (int)this.row.size(), (String)"column");
        return this.row.get(idx);
    }

    @Override
    public int length() {
        return this.row.size();
    }

    @Override
    public Iterator<Object> iterator() {
        return Iterators.transform(this.layout.getColumns().iterator(), this.VALUE_FUNCTION);
    }

    @Override
    public Map<String, Object> asMap() {
        return Maps.asMap((Set)Sets.newHashSet(this.layout.getColumns()), this.VALUE_FUNCTION);
    }
}

