/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.util.table;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.Builder;
import org.grouplens.lenskit.util.table.Row;
import org.grouplens.lenskit.util.table.RowImpl;
import org.grouplens.lenskit.util.table.Table;
import org.grouplens.lenskit.util.table.TableImpl;
import org.grouplens.lenskit.util.table.TableLayout;
import org.grouplens.lenskit.util.table.TableLayoutBuilder;
import org.grouplens.lenskit.util.table.writer.AbstractTableWriter;

public class TableBuilder
extends AbstractTableWriter
implements Builder<Table> {
    private final TableLayout layout;
    private final List<Row> rows;

    public TableBuilder(TableLayout layout) {
        this.layout = layout;
        this.rows = new ArrayList<Row>();
    }

    public TableBuilder(List<String> columns) {
        TableLayoutBuilder bld = new TableLayoutBuilder();
        for (String col : columns) {
            bld.addColumn(col);
        }
        this.layout = bld.build();
        this.rows = new ArrayList<Row>();
    }

    @Override
    public TableLayout getLayout() {
        return this.layout;
    }

    @Override
    public void close() {
    }

    @Override
    public void writeRow(List<?> row) {
        this.addRow(row);
    }

    public synchronized void addRow(List<?> row) {
        this.addRow(row.toArray());
    }

    public synchronized void addRow(Object ... row) {
        this.checkRowWidth(row.length);
        this.rows.add(new RowImpl(this.layout, row));
    }

    public Table build() {
        return new TableImpl(this.layout, this.rows);
    }
}

