/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.util.table;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.grouplens.lenskit.util.table.ColumnImpl;
import org.grouplens.lenskit.util.table.Row;
import org.grouplens.lenskit.util.table.Table;
import org.grouplens.lenskit.util.table.TableLayout;

@Immutable
class TableImpl
extends AbstractList<Row>
implements Table {
    private ArrayList<Row> rows;
    private final TableLayout layout;

    TableImpl(TableLayout layout, Iterable<Row> rws) {
        this.rows = Lists.newArrayList(rws);
        this.layout = layout;
    }

    @Override
    public TableImpl filter(final String col, final Object data) {
        Predicate<Row> pred = new Predicate<Row>(){

            public boolean apply(Row input) {
                return data.equals(input.value(col));
            }
        };
        Iterable filtered = Iterables.filter(this.rows, (Predicate)pred);
        return new TableImpl(this.layout, filtered);
    }

    @Override
    public int size() {
        return this.rows.size();
    }

    @Override
    @Nonnull
    public Iterator<Row> iterator() {
        return this.rows.iterator();
    }

    @Override
    public Row get(int i) {
        return this.rows.get(i);
    }

    @Override
    public ColumnImpl column(String col) {
        return new ColumnImpl(this, this.layout.columnIndex(col), col);
    }

    @Override
    public ColumnImpl column(int idx) {
        Preconditions.checkElementIndex((int)idx, (int)this.layout.getColumnCount(), (String)"column");
        return new ColumnImpl(this, idx, this.layout.getColumns().get(idx));
    }

    @Override
    public TableLayout getLayout() {
        return this.layout;
    }
}

