/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.util.table;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.List;

public class TableLayout {
    private final List<String> names;
    private final Object2IntMap<String> indexes;

    TableLayout(Collection<String> colNames) {
        this.names = ImmutableList.copyOf(colNames);
        this.indexes = new Object2IntOpenHashMap(this.names.size());
        for (String col : this.names) {
            this.indexes.put((Object)col, this.indexes.size());
        }
        this.indexes.defaultReturnValue(-1);
    }

    public List<String> getColumns() {
        return this.names;
    }

    public int columnIndex(String col) {
        int idx = this.indexes.getInt((Object)col);
        if (idx < 0) {
            throw new IllegalArgumentException(col + ": no such column");
        }
        return idx;
    }

    public int getColumnCount() {
        return this.names.size();
    }
}

