/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.util.table;

import java.util.LinkedHashSet;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.exception.CloneFailedException;
import org.grouplens.lenskit.util.table.TableLayout;

public class TableLayoutBuilder
implements Builder<TableLayout>,
Cloneable {
    private LinkedHashSet<String> columns = new LinkedHashSet();

    public static TableLayoutBuilder copy(TableLayout layout) {
        TableLayoutBuilder bld = new TableLayoutBuilder();
        for (String col : layout.getColumns()) {
            bld.addColumn(col);
        }
        return bld;
    }

    public TableLayoutBuilder addColumn(String name) {
        if (name == null) {
            throw new IllegalArgumentException("column name cannot be null");
        }
        if (this.columns.contains(name)) {
            throw new IllegalArgumentException("column " + name + " already exists");
        }
        this.columns.add(name);
        return this;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public TableLayoutBuilder clone() {
        TableLayoutBuilder copy = null;
        try {
            copy = (TableLayoutBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CloneFailedException((Throwable)e);
        }
        copy.columns = new LinkedHashSet<String>(this.columns);
        return copy;
    }

    public TableLayout build() {
        return new TableLayout(this.columns);
    }
}

