/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.util.table.writer;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringEscapeUtils;
import org.grouplens.lenskit.util.io.CompressionMode;
import org.grouplens.lenskit.util.io.LKFileUtils;
import org.grouplens.lenskit.util.table.TableLayout;
import org.grouplens.lenskit.util.table.writer.AbstractTableWriter;

public class CSVWriter
extends AbstractTableWriter {
    private Writer writer;
    private TableLayout layout;

    public CSVWriter(@Nonnull Writer w, @Nullable TableLayout l) throws IOException {
        Preconditions.checkNotNull((Object)w, (Object)"writer must not be null");
        this.layout = l;
        this.writer = w;
        if (this.layout != null) {
            this.writeRow(this.layout.getColumns().toArray(new String[l.getColumnCount()]));
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        this.writer = null;
    }

    @Override
    public synchronized void writeRow(List<?> row) throws IOException {
        if (this.layout != null) {
            this.checkRowWidth(row.size());
        }
        boolean first = true;
        for (Object val : row) {
            if (!first) {
                this.writer.write(44);
            }
            first = false;
            if (val == null) continue;
            this.writer.write(StringEscapeUtils.escapeCsv((String)val.toString()));
        }
        this.writer.write(10);
        this.writer.flush();
    }

    @Override
    public TableLayout getLayout() {
        return this.layout;
    }

    public static CSVWriter open(File file, TableLayout layout, CompressionMode compression) throws IOException {
        Files.createParentDirs((File)file);
        Writer writer = LKFileUtils.openOutput((File)file, (Charset)Charset.defaultCharset(), (CompressionMode)compression);
        try {
            return new CSVWriter(writer, layout);
        }
        catch (Exception ex) {
            Closeables.close((Closeable)writer, (boolean)true);
            Throwables.propagateIfInstanceOf((Throwable)ex, IOException.class);
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public static CSVWriter open(File file, @Nullable TableLayout layout) throws IOException {
        return CSVWriter.open(file, layout, CompressionMode.AUTO);
    }
}

