/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.util.table.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.grouplens.lenskit.util.table.TableLayout;
import org.grouplens.lenskit.util.table.writer.TableWriter;

public class MultiplexedTableWriter
implements TableWriter {
    private TableLayout layout;
    private List<TableWriter> writers;

    public MultiplexedTableWriter(TableLayout layout, List<TableWriter> writers) {
        this.layout = layout;
        this.writers = writers;
    }

    public MultiplexedTableWriter(TableLayout layout, TableWriter ... writers) {
        this(layout, Arrays.asList(writers));
    }

    @Override
    public TableLayout getLayout() {
        return this.layout;
    }

    @Override
    public void writeRow(Object[] row) throws IOException {
        for (TableWriter w : this.writers) {
            w.writeRow(row);
        }
    }

    @Override
    public void writeRow(List<?> row) throws IOException {
        for (TableWriter w : this.writers) {
            w.writeRow(row);
        }
    }

    @Override
    public void close() throws IOException {
        ArrayList<IOException> closeExceptions = new ArrayList<IOException>(this.writers.size());
        for (TableWriter w : this.writers) {
            try {
                w.close();
            }
            catch (IOException e) {
                closeExceptions.add(e);
            }
        }
        if (!closeExceptions.isEmpty()) {
            throw (IOException)closeExceptions.get(0);
        }
    }
}

