/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.util.table.writer;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.util.List;
import org.grouplens.lenskit.util.table.TableLayout;
import org.grouplens.lenskit.util.table.TableLayoutBuilder;
import org.grouplens.lenskit.util.table.writer.AbstractTableWriter;
import org.grouplens.lenskit.util.table.writer.TableWriter;

class PrefixedTableWriter
extends AbstractTableWriter {
    private ObjectArrayList<Object> rowData;
    private int fixedColumns;
    private TableLayout layout;
    private TableWriter baseWriter;

    public PrefixedTableWriter(TableWriter writer, List<?> values) {
        this.baseWriter = writer;
        TableLayout baseLayout = writer.getLayout();
        if (values.size() > baseLayout.getColumnCount()) {
            throw new IllegalArgumentException("Value array too wide");
        }
        this.rowData = new ObjectArrayList(writer.getLayout().getColumnCount());
        this.rowData.addAll(values);
        this.fixedColumns = values.size();
        TableLayoutBuilder bld = new TableLayoutBuilder();
        List<String> bheaders = baseLayout.getColumns();
        for (String h : bheaders.subList(this.fixedColumns, bheaders.size())) {
            bld.addColumn(h);
        }
        this.layout = bld.build();
        assert (this.layout.getColumnCount() + this.rowData.size() == writer.getLayout().getColumnCount());
    }

    @Override
    public TableLayout getLayout() {
        return this.layout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void writeRow(List<?> row) throws IOException {
        this.checkRowWidth(row.size());
        assert (this.rowData.size() == this.fixedColumns);
        this.rowData.addAll(row);
        try {
            this.baseWriter.writeRow((List<?>)this.rowData);
        }
        finally {
            this.rowData.removeElements(this.fixedColumns, this.rowData.size());
        }
    }
}

