/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import org.hibernate.search.FullTextSession;
import org.hibernate.search.backend.BackendQueueProcessorFactory;
import org.hibernate.search.backend.impl.blackhole.BlackHoleBackendQueueProcessorFactory;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueProcessorFactory;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomBackendTest {
    @Test
    public void test() {
        this.verifyBackendUsage("blackhole", BlackHoleBackendQueueProcessorFactory.class);
        this.verifyBackendUsage("lucene", LuceneBackendQueueProcessorFactory.class);
        this.verifyBackendUsage(BlackHoleBackendQueueProcessorFactory.class);
        this.verifyBackendUsage(LuceneBackendQueueProcessorFactory.class);
    }

    private void verifyBackendUsage(String name, Class<? extends BackendQueueProcessorFactory> backendType) {
        FullTextSessionBuilder builder = new FullTextSessionBuilder();
        FullTextSession ftSession = builder.setProperty("hibernate.search.worker.backend", name).openFullTextSession();
        SearchFactoryImplementor searchFactory = (SearchFactoryImplementor)ftSession.getSearchFactory();
        ftSession.close();
        Assert.assertEquals(backendType, searchFactory.getBackendQueueProcessorFactory().getClass());
        builder.close();
    }

    public void verifyBackendUsage(Class<? extends BackendQueueProcessorFactory> backendType) {
        this.verifyBackendUsage(backendType.getName(), backendType);
    }
}

