/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import org.hibernate.cfg.Configuration;
import org.hibernate.search.backend.configuration.IndexWriterSetting;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.FSDirectoryProvider;
import org.hibernate.search.store.IndexShardingStrategy;
import org.hibernate.search.store.RAMDirectoryProvider;
import org.hibernate.search.test.Document;
import org.hibernate.search.test.configuration.ConfigurationReadTestCase;
import org.hibernate.search.test.configuration.UselessShardingStrategy;
import org.hibernate.search.test.query.Author;
import org.hibernate.search.test.query.Book;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShardsConfigurationTest
extends ConfigurationReadTestCase {
    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.sharding_strategy.nbr_of_shards", "2");
        cfg.setProperty("hibernate.search.default.directory_provider", "filesystem");
        cfg.setProperty("hibernate.search.default.2.directory_provider", "ram");
        cfg.setProperty("hibernate.search.Documents.batch.max_buffered_docs", "4");
        cfg.setProperty("hibernate.search.Documents.batch.max_merge_docs", "5");
        cfg.setProperty("hibernate.search.Documents.transaction.max_buffered_docs", "6");
        cfg.setProperty("hibernate.search.Documents.sharding_strategy.nbr_of_shards", "4");
        cfg.setProperty("hibernate.search.Documents.sharding_strategy", UselessShardingStrategy.class.getCanonicalName());
        cfg.setProperty("hibernate.search.Documents.sharding_strategy.test.system.default", "45");
        cfg.setProperty("hibernate.search.Documents.sharding_strategy.test.output", "70");
        cfg.setProperty("hibernate.search.Documents.0.batch.max_merge_docs", "57");
        cfg.setProperty("hibernate.search.Documents.0.directory_provider", RAMDirectoryProvider.class.getCanonicalName());
        cfg.setProperty("hibernate.search.Documents.0.transaction.max_buffered_docs", "58");
        cfg.setProperty("hibernate.search.Documents.1.batch.max_merge_docs", "11");
        cfg.setProperty("hibernate.search.Documents.1.transaction.max_buffered_docs", "12");
        cfg.setProperty("hibernate.search.Documents.1.transaction.term_index_interval", "12");
    }

    public void testCorrectNumberOfShardsDetected() {
        DirectoryProvider[] docDirProviders = this.getSearchFactory().getDirectoryProviders(Document.class);
        ShardsConfigurationTest.assertNotNull((Object)docDirProviders);
        ShardsConfigurationTest.assertEquals((int)4, (int)docDirProviders.length);
        DirectoryProvider[] bookDirProviders = this.getSearchFactory().getDirectoryProviders(Book.class);
        ShardsConfigurationTest.assertNotNull((Object)bookDirProviders);
        ShardsConfigurationTest.assertEquals((int)2, (int)bookDirProviders.length);
    }

    public void testSelectionOfShardingStrategy() {
        IndexShardingStrategy shardingStrategy = this.getSearchFactory().getDocumentBuilderIndexedEntity(Document.class).getDirectoryProviderSelectionStrategy();
        ShardsConfigurationTest.assertNotNull((Object)shardingStrategy);
        ShardsConfigurationTest.assertEquals(shardingStrategy.getClass(), UselessShardingStrategy.class);
    }

    public void testShardingSettingsInherited() {
        DirectoryProvider[] docDirProviders = this.getSearchFactory().getDirectoryProviders(Document.class);
        ShardsConfigurationTest.assertTrue((boolean)(docDirProviders[0] instanceof RAMDirectoryProvider));
        ShardsConfigurationTest.assertTrue((boolean)(docDirProviders[1] instanceof FSDirectoryProvider));
        ShardsConfigurationTest.assertTrue((boolean)(docDirProviders[2] instanceof RAMDirectoryProvider));
        this.assertValueIsSet(Document.class, 0, ConfigurationReadTestCase.TransactionType.BATCH, IndexWriterSetting.MAX_BUFFERED_DOCS, 4);
    }

    public void testShardN2UsesDefaults() {
        this.assertValueIsSet(Document.class, 2, ConfigurationReadTestCase.TransactionType.TRANSACTION, IndexWriterSetting.MAX_BUFFERED_DOCS, 6);
        this.assertValueIsDefault(Document.class, 2, ConfigurationReadTestCase.TransactionType.TRANSACTION, IndexWriterSetting.MAX_MERGE_DOCS);
        this.assertValueIsSet(Document.class, 2, ConfigurationReadTestCase.TransactionType.TRANSACTION, IndexWriterSetting.MERGE_FACTOR, 100);
        this.assertValueIsDefault(Document.class, 2, ConfigurationReadTestCase.TransactionType.TRANSACTION, IndexWriterSetting.RAM_BUFFER_SIZE);
        this.assertValueIsSet(Document.class, 2, ConfigurationReadTestCase.TransactionType.BATCH, IndexWriterSetting.MAX_BUFFERED_DOCS, 4);
        this.assertValueIsSet(Document.class, 2, ConfigurationReadTestCase.TransactionType.BATCH, IndexWriterSetting.MAX_MERGE_DOCS, 5);
        this.assertValueIsDefault(Document.class, 2, ConfigurationReadTestCase.TransactionType.BATCH, IndexWriterSetting.MERGE_FACTOR);
        this.assertValueIsDefault(Document.class, 2, ConfigurationReadTestCase.TransactionType.BATCH, IndexWriterSetting.RAM_BUFFER_SIZE);
    }

    public void testShardN1_ExplicitParams() {
        this.assertValueIsSet(Document.class, 1, ConfigurationReadTestCase.TransactionType.TRANSACTION, IndexWriterSetting.MAX_BUFFERED_DOCS, 12);
        this.assertValueIsSet(Document.class, 1, ConfigurationReadTestCase.TransactionType.BATCH, IndexWriterSetting.MAX_MERGE_DOCS, 11);
    }

    @Override
    protected void ensureIndexesAreEmpty() {
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Book.class, Author.class, Document.class};
    }
}

