/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.nested;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.test.embedded.nested.AttributeValue;
import org.hibernate.search.test.embedded.nested.Product;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class Attribute {
    @Id
    @GeneratedValue
    private long id;
    @ManyToOne
    @ContainedIn
    private Product product;
    @OneToMany(mappedBy="attribute", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @IndexedEmbedded
    private List<AttributeValue> values;

    private Attribute() {
        this.values = new ArrayList<AttributeValue>();
    }

    public Attribute(Product product) {
        this.product = product;
        this.values = new ArrayList<AttributeValue>();
    }

    public long getId() {
        return this.id;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public List<AttributeValue> getValues() {
        return this.values;
    }

    public void setValue(AttributeValue value) {
        this.values.add(value);
    }
}

