/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jgroups.master;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.jms.master.TShirt;
import org.jgroups.JChannel;
import org.jgroups.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JGroupsMasterTest
extends SearchTestCase {
    public static final String CHANNEL_NAME = UUID.randomUUID().toString();
    private JChannel channel;

    public void testMessageSending() throws Exception {
        TShirt shirt = this.createObjectWithSQL();
        List<LuceneWork> queue = this.createDocumentAndWorkQueue(shirt);
        this.sendMessage(queue);
        Thread.sleep(50L);
        FullTextSession ftSess = Search.getFullTextSession((Session)this.openSession());
        ftSess.getTransaction().begin();
        QueryParser parser = new QueryParser(JGroupsMasterTest.getTargetLuceneVersion(), "id", SearchTestCase.stopAnalyzer);
        Query luceneQuery = parser.parse("logo:jboss");
        FullTextQuery query = ftSess.createFullTextQuery(luceneQuery, new Class[0]);
        List result = query.list();
        JGroupsMasterTest.assertEquals((int)1, (int)result.size());
        ftSess.delete(result.get(0));
        ftSess.getTransaction().commit();
        ftSess.close();
    }

    private void prepareJGroupsChannel() throws Exception {
        this.channel = new JChannel(this.prepareJGroupsConfigurationString());
        this.channel.connect(CHANNEL_NAME);
    }

    private void sendMessage(List<LuceneWork> queue) throws Exception {
        Message message = new Message(null, null, (Serializable)((Object)queue));
        this.channel.send(message);
    }

    private List<LuceneWork> createDocumentAndWorkQueue(TShirt shirt) {
        Document doc = new Document();
        Field field = new Field("_hibernate_class", shirt.getClass().getName(), Field.Store.YES, Field.Index.NOT_ANALYZED);
        doc.add((Fieldable)field);
        field = new Field("id", "1", Field.Store.YES, Field.Index.NOT_ANALYZED);
        doc.add((Fieldable)field);
        field = new Field("logo", shirt.getLogo(), Field.Store.NO, Field.Index.ANALYZED);
        doc.add((Fieldable)field);
        AddLuceneWork luceneWork = new AddLuceneWork((Serializable)Integer.valueOf(shirt.getId()), String.valueOf(shirt.getId()), shirt.getClass(), doc);
        ArrayList<LuceneWork> queue = new ArrayList<LuceneWork>();
        queue.add((LuceneWork)luceneWork);
        return queue;
    }

    private TShirt createObjectWithSQL() {
        Session s = this.openSession();
        s.getTransaction().begin();
        TShirt ts = new TShirt();
        ts.setId(1);
        ts.setLogo("JBoss balls");
        ts.setSize("large");
        s.persist((Object)ts);
        s.getTransaction().commit();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)s);
        fullTextSession.beginTransaction();
        fullTextSession.purge(TShirt.class, (Serializable)Integer.valueOf(1));
        fullTextSession.getTransaction().commit();
        s.close();
        return ts;
    }

    public static Session getSession() throws HibernateException {
        return sessions.openSession();
    }

    protected void setUp() throws Exception {
        this.prepareJGroupsChannel();
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        this.channel.close();
        super.tearDown();
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.worker.backend", "jgroupsMaster");
        cfg.setProperty("hibernate.search.worker.backend.jgroups.clusterName", CHANNEL_NAME);
        cfg.setProperty("hibernate.search.worker.backend.jgroups.configurationString", this.prepareJGroupsConfigurationString());
    }

    private String prepareJGroupsConfigurationString() {
        return "UDP(mcast_addr=228.1.2.3;mcast_port=45566;ip_ttl=32):PING(timeout=100;num_initial_members=2):FD(timeout=500):VERIFY_SUSPECT(timeout=500):pbcast.NAKACK(gc_lag=10;retransmit_timeout=3000):UNICAST(timeout=5000):FRAG:pbcast.GMS(join_timeout=30;shun=false;print_local_addr=true)";
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{TShirt.class};
    }
}

